import React from 'react'
import { Button, Checkbox, Link, Modal, ModalBody, ModalContent, ModalFooter, ModalHeader } from '@nextui-org/react'
import { useAuth } from '@/auth/AuthContext'
import type { Answer } from '@/types/chat'

interface LoginModalProps {
  isOpen: boolean
  answer: Answer
  onClose: () => void
}

export const LoginModal: React.FC<LoginModalProps> = ({ isOpen, onClose }) => {
  const { login } = useAuth()

  const [isSelected, setIsSelected] = React.useState(false)

  const handleLogin = () => {
    login()
  }

  return (
    <Modal backdrop="blur" isOpen={isOpen} onClose={onClose}>
      <ModalContent>
        {onClose => (
          <>
            <ModalHeader className="flex flex-col gap-1">欢迎您使用晓得AI助手</ModalHeader>
            <ModalBody className="text-[#27353C]">
              <p>
                为帮助您更好了解晓得AI 助手服务内容，保障您的合法权益。
              </p>
              <p>
                请您认真阅读《服务协议》《隐私政策》 ，特别是其中有关使用限制、免责声明、个人信息保护等内容。
              </p>
              <p>
                您需在仔细阅读并确认同意相关协议后方可使用本服务。
              </p>
              <p>
                <Checkbox
                  isSelected={isSelected}
                  onValueChange={setIsSelected}
                >
                </Checkbox>
                我已阅读并同意
                <Link isExternal href="https://sit-sdream-public-1300557051.insurbank.cn/config-center/agreement/%E6%99%93%E5%BE%97AI%E5%8A%A9%E6%89%8B%E6%9C%8D%E5%8A%A1%E5%8D%8F%E8%AE%AE.html" showAnchorIcon underline="hover">《服务协议》</Link>
                <Link isExternal href="https://sit-sdream-public-1300557051.insurbank.cn/config-center/agreement/%E6%99%93%E5%BE%97AI%E5%8A%A9%E6%89%8B%E9%9A%90%E7%A7%81%E6%94%BF%E7%AD%96.html" showAnchorIcon underline="hover">《隐私政策》</Link>
              </p>
            </ModalBody>
            <ModalFooter>
              <Button onPress={onClose}>
                再想想
              </Button>
              <Button isDisabled={!isSelected} color="primary" onPress={handleLogin}>
                同意
              </Button>
            </ModalFooter>
          </>
        )}
      </ModalContent>
    </Modal>
  )
}
