import { useParams } from 'react-router-dom'
import { ChatSlogan } from '../Chat/components/ChatSlogan'
import { ChatMaskBar } from '../Chat/components/ChatMaskBar'
import styles from './Protocol.module.less'
import TracingBeam from '@/components/TracingBeam/index'

const dummyContent01 = [
  {
    title: '晓得AI助手服务协议',
    description: (
      <p>
        欢迎您使用晓得AI助手服务（以下简称“本服务”）。在您使用本服务之前，请您务必审慎阅读、充分理解《晓得AI助手服务协议》（以下简称“本协议”）。我们在此善意地提醒您，本协议中与您存在重大关系的条款，我们已采用字体加粗的方式来特别提醒您，请您留意重点查阅。您点击“同意”按钮，即视为您已经阅读并同意本协议。本协议即在您和我们之间产生法律效力，成为对双方均具有约束力的法律文件。
      </p>
    ),
  },
  {
    description: (
      <>
        <p>
          1.1 输入内容：指您在使用本服务过程中，在对话框内输入的文本内容。
        </p>
        <p>
          1.2 输出内容：指本服务根据您的输入内容以及其他处理指令所产生的全部输出内容，形式上包括但不限于文字、图片等。
        </p>
      </>
    ),
    title: '一、相关定义',
  },
  {
    description: (
      <p>
        本服务仅适用于使用晓得AI助手用户，不对公众开放使用。
      </p>
    ),
    title: '二、适用对象',
  },
  {
    description: (
      <>
        <p>
          3.1 本服务基于AI大模型技术提供的人工智能服务。本服务主要提供保险产品智能问答、产品智能对比、产品条款解读、产品试算、智能营销话术、后台多轮对话意图总结归纳、情绪分析识别等服务功能以及后续可能推出的并纳入本服务范畴内的其他服务，具体服务以我们实际提供的为准。
        </p>
        <p>
          3.2本服务系由第三方为您提供大模型服务的技术支持。您知悉并同意，有权自行选择、决定与之开展合作的第三方大模型技术支持者。同时请您放心，在与合作方开展合作的过程中，会在法律法规允许的范围内对相关合作方的行为进行有效约束，以保护您在使用本服务过程中的合法权益。
        </p>
      </>
    ),
    title: '三、服务范围',
  },
  {
    description: (
      <>
        <p>
          4.1 合法使用：您使用本服务时，不得以任何方式阻碍或破坏本服务的正常运行，不得诱导本服务生成任何违反法律法规、社会公德或公序良俗的内容，不得侵害他人合法权益（包括但不限于著作权、专利权、商标权、商业秘密等知识产权与其他权益）。同时，您承诺在使用本服务过程中，不会披露、使用或涉及包括您在内的任何主体的保密信息、重要数据、敏感信息或个人隐私信息。
        </p>
        <p>
          4.2 用途限制：本服务仅对晓得用户开放使用，主要提供业务支撑，您不得在业务范围目的之外使用本服务。
        </p>
        <p>
          4.3 权利限制：您知悉并理解，依据本协议，我们授予您一项个人的、可撤销的、不可转让的、非独占地合法使用本服务的权利。
        </p>
      </>
    ),
    title: '四、使用限制',
  },
  {
    description: (
      <>
        <p>
          5.1 您使用本服务时不应超出本服务约定范围输入您或他人的任何个人信息、隐私信息或根据您负有保密义务的信息，对于您执意输入上述信息由此引发的任何法律后果或风险，我们不承担任何责任。
        </p>
        <p>
          5.2 受限于现有技术水平，我们仅依现状提供本服务，输出内容亦可能会出现事实、观点、价值等方面的瑕疵，我们对此不承担任何法律责任。我们将持续改善AI水平以提升输出内容的准确性、完整性、时效性、可用性。
        </p>
        <p>
          5.3 本服务输出内容仅供参考，不代表晓得的态度、观点或立场，亦不构成专业的投资建议。您应根据具体业务情形，结合自身的业务经验，为客户提供咨询问题解答和方案建议。我们对于任何依据本服务输出内容所做出的决定或采取的行动不承担任何责任。
        </p>
        <p>
          5.4 我们对您违反法律法规的规定或者本协议的相关规定使用本服务，从而招致任何的索赔、处罚、赔偿等，不承担任何责任。您违反法律法规的规定或者本协议的相关规定使用本服务造成直接损失和间接损失（包括但不限于经济、商誉、维权支出、律师费等损失）的，我们有权向您追偿。
        </p>
      </>
    ),
    title: '五、免责条款',
  },
  {
    description: (
      <p>
        我们非常重视您的个人信息，在您使用本服务时，您同意我们按照《晓得AI助手隐私政策》收集、存储、使用和保护您的个人信息。《晓得AI助手隐私政策》为本协议不可分割的组成部分。
      </p>
    ),
    title: '六、信息安全与隐私保护',
  },
  {
    description: (
      <>
        <p>
          7.1 本协议的订立、执行和解释及争议的解决均应适用中华人民共和国大陆地区法律。
        </p>
        <p>
          7.2 如双方就本协议内容或其执行发生任何争议，双方应尽量友好协商解决。
        </p>
      </>
    ),
    title: '七、法律管辖',
  },
  {
    description: (
      <>
        <p>
          8.1请您注意，本服务相关服务界面公示的规则及提示内容，均为本协议不可分割的一部分。
        </p>
        <p>
          8.2 本协议是您与我们之间关于您使用本服务所达成的法律协议，除非法律法规另有强制性规定，否则本协议在发生变更后一经公布即替代原协议条款并自动生效。如您在我们修改本协议后继续使用本服务，即被视作您已阅读并同意本协议修改后的全部条款。
        </p>
        <p>
          8.3 本协议的有效期与您享有本服务的服务期限一致。我们有权随时自行决定终止本服务中某一项或某几项服务的运营。
        </p>
        <p>
          8.4 如果您对本协议及本服务有任何问题、疑惑，请随时联系我们。您可以点击对话页面的“回踩”按键，在弹出的弹窗中输入遇到的具体问题进行反馈与投诉建议。
        </p>
      </>
    ),
    title: '七、法律管辖',
  },
]

const dummyContent02 = [
  {
    title: '晓得AI助手隐私政策',
    description: (
      <div className="leading-[32px]">
        <p>
          欢迎您使用 “晓得AI助手”服务（以下简称“本服务”）。我们非常注重您的个人信息及隐私安全，我们特制定《晓得AI助手隐私政策》（以下或称“本隐私政策”或“本政策”）向您阐明我们收集和处理个人信息的规则。
        </p>
        <p>
          在您开始使用我们的产品和服务前，请您务必先仔细阅读和理解本政策，特别应重点阅读我们以粗体标识的条款，确保您充分理解和同意之后再开始使用。若您开始使用本服务，即表示您已充分理解并同意本政策，并且同意我们按照本政策收集和处理您的个人信息。
        </p>
        <p>
          本政策将帮助您了解以下内容：
        </p>
        <p>
          一、适用范围
          <br />

          二、我们如何收集和使用您的个人信息
          <br />

          三、我们如何共享、转让、公开披露您的个人信息
          <br />

          四、我们如何保存您的个人信息
          <br />

          五、我们如何保护您的个人信息
          <br />

          六、您如何管理您的个人信息
          <br />

          七、未成年人个人信息的保护
          <br />

          八、本政策如何更新
          <br />

          九、您如何联系我们
          <br />
        </p>
        <h3 className="text-xl mt-4">一、适用范围</h3>

        本政策适用于您通过企业微信访问和使用晓得AI助手服务。

        <h3 className="text-xl mt-4">二、我们如何收集和使用您的个人信息</h3>

        （一）帮助您成为我们的用户
        <br />

        本服务的使用以登录企业微信账号为前提。您通过企业微信访问和使用本服务，我们将收集您用户信息，以帮助您成为我们的用户并向您提供服务。
        <br />

        （二）人机交互对话
        <br />

        当您使用人机交互对话服务时，我们会收集您在交互过程中自愿输入的对话信息，并使用这些信息向您输出内容，以提供人机交互对话服务。
        <br />

        请您注意，您是否在对话中输入个人信息、输入何种个人信息完全由您个人决定。如您向本服务输入敏感个人信息，尽管我们将采取充分的安全保障措施，该等信息一旦被泄露或不当利用仍然可能对个人信息主体的人身、财产安全或人格权益造成侵害。我们不建议您在对话中输入可能对您的合法权益造成影响的个人信息、未经授权的他人个人信息以及您负有保密义务的信息。
        <br />
        （三）服务评价与意见反馈
        <br />

        在对话过程中，您可以对本服务所输出的内容进行评价和意见反馈，具体而言：您可以通过本服务提供的“点赞/点踩”功能表达您使用本服务的感受；还可以在“点踩”后弹出的弹窗中对您在使用本服务遇到的具体问题进行填写，反馈您对使用本服务的意见和建议。为了不断改善本服务的质量和稳定性，我们将收集您的点赞/点踩记录以及反馈信息。
        <br />
        （四）问答历史
        <br />

        为向您提供连续性、一致化的使用体验，保障服务质量，我们会记录您的个人对话记录，包括您输入的对话信息、以及基于上述信息形成的对话主题。您可以通过点击页面左侧导航键进入“历史会话”板块，查找和管理您的问答历史。
        <br />
        （五）会话收藏
        <br />

        在您使用人机对话服务时，您可以对会话内容进行收藏（星标）操作，我们会收集您的收藏记录，便于您及时查找您所收藏的会话内容。您可以点击会话输入框底部的“会话收藏”按键，查询和管理您收藏的会话信息。
        <br />

        （六）收集和使用个人信息的其他规则
        <br />

        若您提供的信息中含有他人的个人信息，在向我们提供这些个人信息之前，您需确保您已经取得合法的授权。
        <br />

        若我们将个人信息用于本政策未载明的其他用途，或者将基于特定目的收集而来的个人信息用于其他目的，均会事先获得您的同意。
        <br />

        为不断改善本服务的服务质量、提升我们的业务服务水平，我们将在符合法律规定的前提下，对您使用本服务的输入内容和输出内容进行数据统计与数据分析。您完全理解并接受该处理行为，并不因该处理行为而向我们主张权利或主张我们侵犯您的权益。
        <br />

        如我们停止运营本服务，我们将及时停止继续收集您个人信息的活动，将停止运营的通知以逐一送达或公告的形式通知您，并对我们所持有的与已关停业务相关的个人信息进行删除或匿名化处理。
        <br />

        （七）征得授权同意的例外
        <br />

        根据相关法律法规规定，我们在以下情况下收集、使用您的个人信息无需您的授权同意：
        <br />

        （1）为订立、履行个人作为一方当事人的合同所必需，或者按照依法制定的劳动规章制度和依法签订的集体合同实施人力资源管理所必需；
        <br />

        （2）为履行法定职责或者法定义务所必需；
        <br />

        （3）为应对突发公共卫生事件，或者紧急情况下为保护自然人的生命健康和财产安全所必需；
        <br />

        （4）为公共利益实施新闻报道、舆论监督等行为，在合理的范围内处理个人信息；
        <br />

        （5）依照本法规定在合理的范围内处理个人自行公开或者其他已经合法公开的个人信息；
        <br />

        （6）法律、行政法规规定的其他情形。
        <br />

        <h3 className="text-xl mt-4">三、我们如何共享、转让、公开披露您的个人信息</h3>
        <br />
        （一）共享
        <br />
        我们不会主动共享您的个人信息，除非获得您的明确同意或您主动选择共享的情况下，向您指定的第三方共享您授权范围内的个人信息。
        <br />
        （二）转让
        <br />
        原则上，我们不会将您的个人信息转让给任何公司、组织和个人等其他主体处理，但以下情况除外：
        <br />
        （1）我们已就转让事宜获得您明确的同意或授权；
        <br />
        （2）根据适用的法律法规、法律程序的规定，或政府主管部门或司法部门的要求所必须的情况下进行转让；
        <br />
        （3）符合与您签署的相关协议（包括在线签署的电子协议以及相应的平台规则）或其他的法律文件约定所提供；
        <br />
        （4）在涉及合并、收购或破产清算时，如涉及个人信息转让，我们会再要求新的持有您个人信息的公司、组织继续受此隐私政策的约束，否则我们将要求该公司、组织重新向您征求授权同意。
        <br />
        （三）公开披露
        <br />
        我们不会主动公开您未曾自行公开的个人信息，但以下情况除外：
        <br />
        1.根据您的需求，在您明确同意的披露方式下披露您所指定的个人信息；
        <br />
        2.根据适用的法律法规、法律程序的规定，或政府主管部门或司法部门的要求所必须的情况下进行公开披露。
        <br />
        在上述场景下，我们将在采取符合业界标准的安全防护措施的前提下，公开披露您的个人信息。
        <br />
        <h3 className="text-xl mt-4">四、我们如何保存您的个人信息</h3>
        <br />
        （一）存储地点
        <br />
        我们依照法律法规的规定，将在中国境内收集和产生的您的个人信息存储于中国境内。
        <br />
        （二）存储期限
        <br />
        我们将在为实现本政策所述目的所需的必要期限内保存您的个人信息，若适用法律法规中有特别要求的，我们将根据法律法规的强制规定保存您的个人信息。
        <br />
        （三）个人信息的删除
        <br />
        除法律法规另有规定或允许更长的存储期限外，我们将在为实现处理目的所必需的期限之内保存您的个人信息。在超出规定的存储期限后，我们将会删除您的个人信息或进行匿名化处理。
        <br />
        当本服务发生停止运营的情形时，我们将按照法律法规的规定，采取包括但不限于邮件、信函、电话、推送等方式告知您，并在终止运营或服务后删除您的所有个人信息或进行匿名化处理。
        <br />
        <h3 className="text-xl mt-4">五、我们如何保护您的个人信息</h3>
        <br />
        （一）技术保护措施
        <br />
        我们会严格遵守中国境内有关个人信息保护的相关法律法规，采取严格的安全保护措施，防止您的个人信息遭到未经授权的泄露、篡改、丢失。
        <br />
        （二）安全事件响应
        <br />
        当我们获悉发生了个人信息安全事件后，我们将按照法律法规的要求及时向您告知：安全事件的基本情况和可能造成的危害、我们采取的补救措施以及您可采取的减轻危害的措施。事件相关情况将以推送通知的方式告知您，难以逐一告知您时，我们会采取合理、有效的方式发布公告。同时，我们还将按照监管部门要求，上报个人信息安全事件的处置情况。
        <br />
        <h3 className="text-xl mt-4">六、您如何管理您的个人信息</h3>
        <br />
        我们非常重视您对个人信息的管理，并尽全力保障您对个人信息权利的行使。
        <br />
        （一）查询、复制、更正和补充您的个人信息
        <br />
        您有权查询、复制、更正或补充您的个人信息。您可以通过以下方式进行：
        <br />
        （1）您可以通过点击页面左侧导航键进入“历史会话”板块，查询您的历史对话信息。
        <br />
        （2）您可以点击会话输入框底部的“会话收藏”按键，查询您收藏的会话信息。
        <br />
        （3）若您无法通过服务页面查询、复制、更正和补充您的个人信息，您可以拨打电话联系我们，联系电话为：400-101-0011。
        <br />
        （二）删除您的个人信息
        <br />
        您有权删除您的个人信息。您可以通过以下方式进行：
        <br />
        （1）您可以通过点击页面左侧导航键进入“历史会话”板块，删除您的历史对话信息。
        <br />
        （2）如您无法通过服务页面删除您的个人信息，您可以拨打“（一）查询、复制、更正和补充您的信息”中列明的联系电话，联系我们协助删除您的个人信息。
        <br />
        当您或我们协助您删除相关个人信息后，因为适用的法律和安全技术限制，我们可能无法立即从备份系统中删除相应的个人信息，我们将安全地存储您的个人信息并限制对其的任何进一步的处理，直到备份可以清除或实现匿名化。
        <br />
        （三）改变您授权同意的范围
        <br />
        您可以拨打“（一）查询、复制、更正和补充您的信息”中列明的联系电话，联系我们协助您改变或者撤回您授权我们收集和处理您的个人信息的范围。当您收回授权后，我们将不再处理相应的个人信息。但您收回授权的决定，不会影响我们此前基于您的授权而开展的个人信息处理。
        <br />
        （四）注销您的账户
        <br />
        您可以拨打“（一）查询、复制、更正和补充您的信息”中列明的联系电话，联系我们协助您申请关闭/注销您的账户。在您的账户注销之后，我们将停止为您提供产品或服务，并根据适用法律的要求删除您的个人信息，或对其进行匿名化处理。
        <br />
        （五）响应您的上述请求
        <br />
        为保障您的账户安全，您向我们提出上述请求时，我们可能会先要求您验证您的身份（如要求您提供书面请求或其他方式），然后再处理您的请求。
        <br />
        对于您向我们提出的上述请求，我们将在15天内作出答复。对于无法实现、可能对他人造成不利影响的请求，我们可能会予以拒绝。
        <br />
        <h3 className="text-xl mt-4">七、未成年人个人信息的保护</h3>
        <br />
        我们的服务面向成年人，我们不主动收集、处理未满18周岁的未成年人的个人信息。如果我们发现自己在事先未知晓的情况下收集了未成年人的个人信息，则会设法尽快删除相关数据。
        <br />
        <h3 className="text-xl mt-4">八、本政策如何更新</h3>
        <br />
        我们可能会适时地修订本政策的内容，本政策更新后，我们会在您登录及版本更新时以推送通知、弹窗等形式向您展示变更后的本政策，以便您及时了解本政策的最新版本。如修订内容涉及个人信息处理的目的、方式、种类内容的变更，我们会依据相关法律规定的要求，就变更后的相关内容重新取得您的同意。
        <br />
        <h3 className="text-xl mt-4">九、您如何联系我们</h3>
        <br />
        若您对本隐私政策有任何疑问或建议，或者您希望获取或更改我们拥有的关于您的信息，请通过以下方式联系我们，通常情况下，我们将在您的身份验证通过后的15个工作日内予以回复：
        <br />
      </div>
    ),
  },
]

export const Protocol: React.FC = () => {
  // id: 01服务协议 02 隐私协议
  const { id } = useParams<{ id: string }>()
  return (
    <div className={`${styles.protocolPage} relative`}>
      <ChatSlogan />
      <ChatMaskBar />
      <TracingBeam className="bg-[#fff] flex-1 text-[#27353C] w-full max-w-[912px]  p-[24px] box-border mx-auto rounded-[20px]">
        <div className="pt-4 relative leading-[32px]">
          {(id === '01' ? dummyContent01 : dummyContent02).map((item, index) => (
            <div key={`content-${index}`}>
              <p className="text-xl mt-4">
                {item.title}
              </p>

              <div className="text-[14px]  prose prose-sm">
                {item.description}
              </div>
            </div>
          ))}
        </div>
      </TracingBeam>
    </div>
  )
}
