import { formatMarkdown } from './markdownFormatter'
import { ChatAnswerAttachment } from './ChatAnswerAttchment'
import { ChatAnswerOperate } from './ChatAnswerOperate'
import type { Answer } from '@/types/chat'
import { MarkdownDetail } from '@/components/MarkdownDetail'

interface ChatAnswerShowerProps {
  answer: Answer
  isLastAnswer: boolean
  onSubmitQuestion: (question: string) => void
}

export const ChatAnswerShower: React.FC<ChatAnswerShowerProps> = ({ answer, isLastAnswer, onSubmitQuestion }) => {
  const hideOperate = (answer.cardList || []).some(attachment => attachment.type === 'box' || attachment?.type?.includes('card-'))
  return (
    <div className="relative flex flex-col gap-[8px]">
      {answer.answer && (
        <MarkdownDetail>
          {formatMarkdown(answer.answer || '')}
        </MarkdownDetail>
      )}
      {answer.cardList && answer.cardList?.length !== 0 && <ChatAnswerAttachment onSubmitQuestion={onSubmitQuestion} isLastAnswer={isLastAnswer} answer={answer} />}
      {!hideOperate && <ChatAnswerOperate answer={answer} />}
    </div>
  )
}
