import React from 'react'
import { motion } from 'framer-motion'
import styles from './GradientsBall.module.less'

export const GradientsBall: React.FC = () => {
  const balls = [
    { id: 'g1' },
    { id: 'g2' },
    { id: 'g3' },
  ]

  return (
    <div className={styles.gradientsBallContainer}>
      {balls.map(ball => (
        <motion.div
          key={ball.id}
          className={(styles as any)[ball.id]}
        >
        </motion.div>
      ))}
    </div>
  )
}
