import { Avatar } from '@heroui/react'
import { motion } from 'framer-motion'
import AvatarBot from '@/assets/avatarBot.png'

export const ChatWelcome: React.FC = () => {
  return (
    <div className="chatWelcomeContainer w-full">
      <div className="h-[20px] sm:h-[32px] w-full"></div>
      <div className="flex">
        <Avatar className="mr-[12px] hidden sm:block flex-shrink-0" src={AvatarBot} />
        <motion.div
          className="sm:ml-[20px] rounded-[20px] box-border px-[16px] py-[16px] sm:px-[24px] sm:py-[20px]"
          style={{ background: '#F7FAFD' }}
        >
          <div className="content">
            <p className="text-[16px] sm:text-[18px] font-medium text-[#333]">您好，有什么我可以帮您的吗？</p>
            {/* <p className="text-[15px] mt-[4px]  sm:mt-[8px] sm:text-13px text-[#27353C] font-300">作为您的智能保险伙伴，您有各类专业相关的问题都可以抛给我哟~让我们互相帮助共同成长吧~</p> */}
          </div>
        </motion.div>
      </div>
      <div className="h-[20px] sm:h-[32px] w-full"></div>
    </div>
  )
}
