import React from 'react'
import { motion } from 'framer-motion'
import styles from './GradientBackground.module.less'
import Bg from '@/assets/bg.png'

export const GradientBackground: React.FC = () => {
  return (
    <motion.div
      className={styles.gradientBackground}
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      transition={{ duration: 2, ease: 'easeOut' }}
    >
      <motion.img src={Bg} alt="" />
    </motion.div>
  )
}
