import type Connect from '../../compiled/connect';
import type { CreateDevMiddlewareReturns } from '../provider/createCompiler';
import type { CreateDevServerOptions, EnvironmentAPI, InternalContext, NormalizedConfig, StartDevServerOptions } from '../types';
import { type UpgradeEvent } from './helper';
export type RsbuildDevServer = {
    /**
     * Use rsbuild inner server to listen
     */
    listen: () => Promise<{
        port: number;
        urls: string[];
        server: {
            close: () => Promise<void>;
        };
    }>;
    /** The following APIs will be used when you use a custom server */
    /** The Rsbuild server environment API */
    environments: EnvironmentAPI;
    /**
     * The resolved port.
     *
     * By default, Rsbuild Server listens on port `3000` and automatically increments the port number when the port is occupied.
     */
    port: number;
    /**
     * connect app instance.
     *
     * Can be used to attach custom middlewares to the dev server.
     */
    middlewares: Connect.Server;
    /**
     * Notify Rsbuild Server has started
     *
     * In Rsbuild, we will trigger onAfterStartDevServer hook in this stage
     */
    afterListen: () => Promise<void>;
    /**
     * Subscribe http upgrade event
     *
     * It will used when you use custom server
     */
    onHTTPUpgrade: UpgradeEvent;
    /**
     * Close the Rsbuild server.
     */
    close: () => Promise<void>;
};
export declare function createDevServer<Options extends {
    context: InternalContext;
}>(options: Options, createDevMiddleware: (options: Options, compiler: StartDevServerOptions['compiler']) => Promise<CreateDevMiddlewareReturns>, config: NormalizedConfig, { compiler: customCompiler, getPortSilently, runCompile, }?: CreateDevServerOptions): Promise<RsbuildDevServer>;
