(() => {
  "use strict";
  var __webpack_modules__ = {
    316: (__unused_webpack_module, exports, __nccwpck_require__) => {
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.transformFiles =
        exports.reduceChunk =
        exports.reduceAssets =
        exports.generateManifest =
          void 0;
      const path_1 = __nccwpck_require__(17);
      const generateManifest = (
        compilation,
        files,
        { generate, seed = {} },
      ) => {
        let result;
        if (generate) {
          const entrypointsArray = Array.from(
            compilation.entrypoints.entries(),
          );
          const entrypoints = entrypointsArray.reduce(
            (e, [name, entrypoint]) =>
              Object.assign(e, { [name]: entrypoint.getFiles() }),
            {},
          );
          result = generate(seed, files, entrypoints);
        } else {
          result = files.reduce(
            (manifest, file) =>
              Object.assign(manifest, { [file.name]: file.path }),
            seed,
          );
        }
        return result;
      };
      exports.generateManifest = generateManifest;
      const getFileType = (fileName, { transformExtensions }) => {
        const replaced = fileName.replace(/\?.*/, "");
        const split = replaced.split(".");
        const extension = split.pop();
        return transformExtensions.test(extension)
          ? `${split.pop()}.${extension}`
          : extension;
      };
      const reduceAssets = (files, asset, moduleAssets) => {
        let name;
        if (moduleAssets[asset.name]) {
          name = moduleAssets[asset.name];
        } else if (asset.info.sourceFilename) {
          name = (0, path_1.join)(
            (0, path_1.dirname)(asset.name),
            (0, path_1.basename)(asset.info.sourceFilename),
          );
        }
        if (name) {
          return files.concat({
            isAsset: true,
            isChunk: false,
            isInitial: false,
            isModuleAsset: true,
            name,
            path: asset.name,
          });
        }
        const isEntryAsset = asset.chunks && asset.chunks.length > 0;
        if (isEntryAsset) {
          return files;
        }
        return files.concat({
          isAsset: true,
          isChunk: false,
          isInitial: false,
          isModuleAsset: false,
          name: asset.name,
          path: asset.name,
        });
      };
      exports.reduceAssets = reduceAssets;
      const reduceChunk = (files, chunk, options, auxiliaryFiles) => {
        Array.from(chunk.auxiliaryFiles || []).forEach((auxiliaryFile) => {
          auxiliaryFiles[auxiliaryFile] = {
            isAsset: true,
            isChunk: false,
            isInitial: false,
            isModuleAsset: true,
            name: (0, path_1.basename)(auxiliaryFile),
            path: auxiliaryFile,
          };
        });
        return Array.from(chunk.files).reduce((prev, path) => {
          let name = chunk.name ? chunk.name : null;
          name = name
            ? options.useEntryKeys && !path.endsWith(".map")
              ? name
              : `${name}.${getFileType(path, options)}`
            : path;
          return prev.concat({
            chunk,
            isAsset: false,
            isChunk: true,
            isInitial: chunk.isOnlyInitial(),
            isModuleAsset: false,
            name,
            path,
          });
        }, files);
      };
      exports.reduceChunk = reduceChunk;
      const standardizeFilePaths = (file) => {
        const result = Object.assign({}, file);
        result.name = file.name.replace(/\\/g, "/");
        result.path = file.path.replace(/\\/g, "/");
        return result;
      };
      const transformFiles = (files, options) =>
        ["filter", "map", "sort"]
          .filter((fname) => !!options[fname])
          .reduce((prev, fname) => prev[fname](options[fname]), files)
          .map(standardizeFilePaths);
      exports.transformFiles = transformFiles;
    },
    662: (__unused_webpack_module, exports, __nccwpck_require__) => {
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.normalModuleLoaderHook =
        exports.getCompilerHooks =
        exports.emitHook =
        exports.beforeRunHook =
          void 0;
      const fs_1 = __nccwpck_require__(147);
      const path_1 = __nccwpck_require__(17);
      const lite_tapable_1 = __nccwpck_require__(348);
      const helpers_1 = __nccwpck_require__(316);
      const compilerHookMap = new WeakMap();
      const getCompilerHooks = (compiler) => {
        let hooks = compilerHookMap.get(compiler);
        if (typeof hooks === "undefined") {
          hooks = {
            afterEmit: new lite_tapable_1.SyncWaterfallHook(["manifest"]),
            beforeEmit: new lite_tapable_1.SyncWaterfallHook(["manifest"]),
          };
          compilerHookMap.set(compiler, hooks);
        }
        return hooks;
      };
      exports.getCompilerHooks = getCompilerHooks;
      const beforeRunHook = (
        { emitCountMap, manifestFileName },
        _,
        callback,
      ) => {
        const emitCount = emitCountMap.get(manifestFileName) || 0;
        emitCountMap.set(manifestFileName, emitCount + 1);
        if (callback) {
          callback();
        }
      };
      exports.beforeRunHook = beforeRunHook;
      const emitHook = function emit(
        {
          compiler,
          emitCountMap,
          manifestAssetId,
          manifestFileName,
          moduleAssets,
          options,
        },
        compilation,
      ) {
        const emitCount = emitCountMap.get(manifestFileName) - 1;
        const stats = compilation
          .getStats()
          .toJson({
            all: false,
            assets: true,
            cachedAssets: true,
            ids: true,
            publicPath: true,
          });
        const publicPath =
          options.publicPath !== null ? options.publicPath : stats.publicPath;
        const { basePath, removeKeyHash } = options;
        emitCountMap.set(manifestFileName, emitCount);
        const auxiliaryFiles = {};
        let files = Array.from(compilation.chunks).reduce(
          (prev, chunk) =>
            (0, helpers_1.reduceChunk)(prev, chunk, options, auxiliaryFiles),
          [],
        );
        files = stats.assets.reduce(
          (prev, asset) =>
            (0, helpers_1.reduceAssets)(prev, asset, moduleAssets),
          files,
        );
        files = files.filter(({ name, path }) => {
          var _a;
          return (
            !path.includes("hot-update") &&
            typeof emitCountMap.get(
              (0, path_1.join)(
                ((_a = compiler.options.output) === null || _a === void 0
                  ? void 0
                  : _a.path) || "<unknown>",
                name,
              ),
            ) === "undefined"
          );
        });
        files.forEach((file) => {
          delete auxiliaryFiles[file.path];
        });
        Object.keys(auxiliaryFiles).forEach((auxiliaryFile) => {
          files = files.concat(auxiliaryFiles[auxiliaryFile]);
        });
        files = files.map((file) => {
          const normalizePath = (path) => {
            if (!path.endsWith("/")) {
              return `${path}/`;
            }
            return path;
          };
          const changes = {
            name: basePath ? normalizePath(basePath) + file.name : file.name,
            path: publicPath
              ? normalizePath(publicPath) + file.path
              : file.path,
          };
          changes.name = removeKeyHash
            ? changes.name.replace(removeKeyHash, "")
            : changes.name;
          return Object.assign(file, changes);
        });
        files = (0, helpers_1.transformFiles)(files, options);
        let manifest = (0, helpers_1.generateManifest)(
          compilation,
          files,
          options,
        );
        const isLastEmit = emitCount === 0;
        manifest = getCompilerHooks(compiler).beforeEmit.call(manifest);
        if (isLastEmit) {
          const output = options.serialize(manifest);
          compilation.emitAsset(
            manifestAssetId,
            new compiler.webpack.sources.RawSource(output),
          );
          if (options.writeToFileEmit) {
            (0, fs_1.mkdirSync)((0, path_1.dirname)(manifestFileName), {
              recursive: true,
            });
            (0, fs_1.writeFileSync)(manifestFileName, output);
          }
        }
        getCompilerHooks(compiler).afterEmit.call(manifest);
      };
      exports.emitHook = emitHook;
      const normalModuleLoaderHook = ({ moduleAssets }, context, module) => {
        const loaderContext = context;
        const { emitFile } = loaderContext;
        loaderContext.emitFile = (file, content, sourceMap) => {
          if (module.userRequest && !moduleAssets[file]) {
            Object.assign(moduleAssets, {
              [file]: (0, path_1.join)(
                (0, path_1.dirname)(file),
                (0, path_1.basename)(module.userRequest),
              ),
            });
          }
          return emitFile.call(module, file, content, sourceMap);
        };
      };
      exports.normalModuleLoaderHook = normalModuleLoaderHook;
    },
    348: (module) => {
      module.exports = require("@rspack/lite-tapable");
    },
    147: (module) => {
      module.exports = require("fs");
    },
    17: (module) => {
      module.exports = require("path");
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = {};
  (() => {
    var exports = __webpack_exports__;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.RspackManifestPlugin =
      exports.WebpackManifestPlugin =
      exports.getCompilerHooks =
        void 0;
    const path_1 = __nccwpck_require__(17);
    const hooks_1 = __nccwpck_require__(662);
    Object.defineProperty(exports, "getCompilerHooks", {
      enumerable: true,
      get: function () {
        return hooks_1.getCompilerHooks;
      },
    });
    const emitCountMap = new Map();
    const defaults = {
      assetHookStage: Infinity,
      basePath: "",
      fileName: "manifest.json",
      filter: null,
      generate: void 0,
      map: null,
      publicPath: null,
      removeKeyHash: /([a-f0-9]{16,32}\.?)/gi,
      seed: void 0,
      serialize(manifest) {
        return JSON.stringify(manifest, null, 2);
      },
      sort: null,
      transformExtensions: /^(gz|map)$/i,
      useEntryKeys: false,
      useLegacyEmit: false,
      writeToFileEmit: false,
    };
    class WebpackManifestPlugin {
      constructor(opts) {
        this.options = Object.assign({}, defaults, opts);
      }
      apply(compiler) {
        var _a, _b;
        const moduleAssets = {};
        const manifestFileName = (0, path_1.resolve)(
          ((_a = compiler.options.output) === null || _a === void 0
            ? void 0
            : _a.path) || "./",
          this.options.fileName,
        );
        const manifestAssetId = (0, path_1.relative)(
          ((_b = compiler.options.output) === null || _b === void 0
            ? void 0
            : _b.path) || "./",
          manifestFileName,
        );
        const beforeRun = hooks_1.beforeRunHook.bind(this, {
          emitCountMap,
          manifestFileName,
        });
        const emit = hooks_1.emitHook.bind(this, {
          compiler,
          emitCountMap,
          manifestAssetId,
          manifestFileName,
          moduleAssets,
          options: this.options,
        });
        const hookOptions = {
          name: "WebpackManifestPlugin",
          stage: this.options.assetHookStage,
        };
        if (this.options.useLegacyEmit === true) {
          compiler.hooks.emit.tap(hookOptions, emit);
        } else {
          compiler.hooks.thisCompilation.tap(hookOptions, (compilation) => {
            compilation.hooks.processAssets.tap(hookOptions, () =>
              emit(compilation),
            );
          });
        }
        compiler.hooks.run.tapAsync(hookOptions, beforeRun);
        compiler.hooks.watchRun.tapAsync(hookOptions, beforeRun);
      }
    }
    exports.WebpackManifestPlugin = WebpackManifestPlugin;
    exports.RspackManifestPlugin = WebpackManifestPlugin;
  })();
  module.exports = __webpack_exports__;
})();
