import type { DevMiddlewareAPI } from '../server/devMiddleware';
import type { DevConfig, InternalContext, Rspack, RspackConfig } from '../types';
import { type InitConfigsOptions } from './initConfigs';
export declare function createCompiler({ context, rspackConfigs, }: {
    context: InternalContext;
    rspackConfigs: RspackConfig[];
}): Promise<Rspack.Compiler | Rspack.MultiCompiler>;
export type MiddlewareCallbacks = {
    onInvalid: () => void;
    onDone: (stats: any) => void;
};
export type DevMiddlewareOptions = {
    /** To ensure HMR works, the devMiddleware need inject the hmr client path into page when HMR enable. */
    clientPaths?: string[];
    clientConfig: DevConfig['client'];
    publicPath?: string;
    /** When liveReload is disabled, the page does not reload. */
    liveReload?: boolean;
    etag?: 'weak' | 'strong';
    /** The options need by compiler middleware (like webpackMiddleware) */
    headers?: Record<string, string | string[]>;
    writeToDisk?: boolean | ((filename: string) => boolean);
    stats?: boolean;
    /** should trigger when compiler hook called */
    callbacks: MiddlewareCallbacks;
    /** whether use Server Side Render */
    serverSideRender?: boolean;
};
export type CreateDevMiddlewareReturns = {
    devMiddleware: (options: DevMiddlewareOptions) => DevMiddlewareAPI;
    compiler: Rspack.Compiler | Rspack.MultiCompiler;
};
export declare function createDevMiddleware(options: InitConfigsOptions, customCompiler?: Rspack.Compiler | Rspack.MultiCompiler): Promise<CreateDevMiddlewareReturns>;
