import type { ChatRecord, OriginalRecord } from '@/types/chat'

export function processApiResponse(data: OriginalRecord[]): ChatRecord[] {
  const chatRecord: ChatRecord[] = []
  if (data.length === 0)
    return chatRecord
  data.forEach((record) => {
    chatRecord.push({
      role: 'user',
      ...record,
    })

    if (record.answerList && record.answerList.length > 0) {
      record.answerList.forEach((answer) => {
        answer.isShow = true
      })
      chatRecord.push({
        role: 'ai',
        ...record,
      })
    }
  })

  return chatRecord
}
