import { useNavigate } from 'react-router-dom'
import TextLogo from '@/assets/svg/textLogo.svg?react'
import GradualSpacing from '@/components/GradualSpacing'

export const ChatSlogan: React.FC = () => {
  const navigate = useNavigate()
  return (
    <div className="w-full">
      <div className="h-[64px] mx-auto sm:h-[112px] flex flex-col justify-center">
        <div className="flex items-center cursor-pointer" onClick={() => navigate('/')}>
          <TextLogo className="w-[46px] sm:w-[70px]" />
          <GradualSpacing text="晓得解惑，让沟通更智能" className="ml-[8px] text-[14px]  sm:text-[16px] text-[#333] font-medium" />
        </div>
        <h3 className="hidden sm:block text-[12px] text-[#333] font-light">知晓市场脉搏，引领行业潮流，晓得AI助手全方位为您保驾护航</h3>
      </div>
    </div>
  )
}
