export function formatMarkdown(text: string): string {
  // 首先移除 ♪ 符号之后的所有文本
  let formattedText = text.split('♪')[0].trim()

  // 处理换行
  formattedText = formattedText.replace(/(?<!\n)\n(?!\n)/g, '  \n')

  // 处理代码块
  formattedText = formattedText.replace(/```(\w+)?\n([\s\S]*?)\n```/g, (match, language, code) => {
    return `\n\`\`\`${language || ''}\n${code.trim()}\n\`\`\`\n`
  })

  // 处理行内代码
  formattedText = formattedText.replace(/`([^`\n]+)`/g, '`$1`')

  // 处理列表
  formattedText = formattedText.replace(/^( *)[-*+] /gm, '$1- ')

  // 处理标题
  formattedText = formattedText.replace(/^(#{1,6}) /gm, '$1 ')

  // 处理粗体和斜体
  formattedText = formattedText.replace(/(\*\*|__)(.*?)\1/g, '**$2**')
  formattedText = formattedText.replace(/(\*|_)(.*?)\1/g, '*$2*')

  // 处理链接
  formattedText = formattedText.replace(/\[([^\]]+)\]\(([^)]+)\)/g, '[$1]($2)')

  return formattedText
}
