import type React from 'react'
import { motion } from 'framer-motion'
import { Button, Tooltip } from '@nextui-org/react'
import styles from './Navbar.module.less'
import { NavBarItem } from './components/NavBarItem'
import UserIcon from '@/assets/svg/user.svg?react'
import type { WithAuthProps } from '@/auth/withAuth'
import { withAuth } from '@/auth/withAuth'
import { NAV_BAR_ITEMS } from '@/config/nav'

interface NavbarProps {
  isCollapsed: boolean
  onToggle: () => void
}

const NavbarBase: React.FC<NavbarProps & WithAuthProps> = ({ showLoginTip, checkAuth, onToggle }) => {
  const handleClick = (type: string | undefined) => {
    if (!checkAuth())
      return

    if (type === 'history') {
      onToggle()
    }
  }

  return (
    <motion.nav className="h-full flex-shrink-0 flex flex-col items-center justify-center">
      <motion.div className={`${styles.layoutNavBarAgent} sm:flex hidden w-[64px] bg-white gap-[24px]`}>
        {NAV_BAR_ITEMS.map((item) => {
          return (
            <NavBarItem onClick={handleClick} icon={item.icon} label={item.label} key={item.key} type={item.key} />
          )
        })}
        <Tooltip isOpen={showLoginTip} color="foreground" content="登录体验更多功能" placement="right">
          <Button onClick={checkAuth} variant="light" isIconOnly aria-label="Like">
            <UserIcon />
          </Button>
        </Tooltip>
      </motion.div>
    </motion.nav>
  )
}

export const Navbar = withAuth(NavbarBase)
