import './App.css'
import React from 'react'
import { BrowserRouter as Router } from 'react-router-dom'
import { MainLayout } from './layouts'
import { AppRoutes } from './routes/AppRoutes'
import { AuthProvider } from './auth/AuthContext'

const App: React.FC = () => {
  return (
    <AuthProvider>
      <Router>
        <MainLayout>
          <AppRoutes />
        </MainLayout>
      </Router>
    </AuthProvider>
  )
}

export default App
