import type { StatsCompilation, StatsValue } from '@rspack/core';
import type RspackChain from '../compiled/rspack-chain';
import type { Compiler as WebpackCompiler, MultiCompiler as WebpackMultiCompiler } from 'webpack';
import type { FilenameConfig, MultiStats, NodeEnv, NormalizedConfig, NormalizedEnvironmentConfig, RsbuildTarget, Rspack, Stats } from './types';
export declare const rspackMinVersion = "0.7.0";
export declare const getNodeEnv: () => NodeEnv;
export declare const setNodeEnv: (env: NodeEnv) => void;
export declare const isDev: () => boolean;
export declare const isProd: () => boolean;
export declare const isNil: (o: unknown) => o is undefined | null;
export declare const isFunction: (func: unknown) => func is (...args: any[]) => any;
export declare const isObject: (obj: unknown) => obj is Record<string, any>;
export declare const isPlainObject: (o: unknown) => o is Record<string, any>;
export declare const castArray: <T>(arr?: T | T[]) => T[];
export declare const cloneDeep: <T>(value: T) => T;
export declare const isSatisfyRspackVersion: (originalVersion: string) => Promise<boolean>;
export declare const getAllStatsErrors: (statsData: StatsCompilation) => Rspack.StatsError[] | undefined;
export declare const getAllStatsWarnings: (statsData: StatsCompilation) => Rspack.StatsError[] | undefined;
export declare function getStatsOptions(compiler: Parameters<typeof isMultiCompiler>[0]): StatsValue | undefined;
export declare function formatStats(stats: Stats | MultiStats, options?: StatsValue): {
    message?: string;
    level?: string;
};
export declare const removeLeadingSlash: (s: string) => string;
export declare const removeTailingSlash: (s: string) => string;
export declare const addTrailingSlash: (s: string) => string;
export declare const formatPublicPath: (publicPath: string, withSlash?: boolean) => string;
export declare const getPublicPathFromChain: (chain: RspackChain, withSlash?: boolean) => string;
export declare const getPublicPathFromCompiler: (compiler: Rspack.Compiler) => string;
export declare const isFileSync: (filePath: string) => boolean | undefined;
export declare function isEmptyDir(path: string): boolean;
/**
 * Find first already exists file.
 * @param files - Absolute file paths with extension.
 * @returns The file path if exists, or false if no file exists.
 */
export declare const findExists: (files: string[]) => string | false;
export declare function pathExists(path: string): Promise<boolean>;
export declare function isFileExists(file: string): Promise<boolean>;
export declare function emptyDir(dir: string): Promise<void>;
export declare const canParse: (url: string) => boolean;
export declare const ensureAssetPrefix: (url: string, assetPrefix?: Rspack.PublicPath) => string;
export declare function getFilename(config: NormalizedConfig | NormalizedEnvironmentConfig, type: 'js', isProd: boolean, isServer?: boolean): NonNullable<FilenameConfig['js']>;
export declare function getFilename(config: NormalizedConfig | NormalizedEnvironmentConfig, type: Exclude<keyof FilenameConfig, 'js'>, isProd: boolean, isServer?: boolean): string;
export declare function partition<T>(array: T[], predicate: (value: T) => boolean): [T[], T[]];
export declare const applyToCompiler: (compiler: Rspack.Compiler | Rspack.MultiCompiler, apply: (c: Rspack.Compiler, index: number) => void) => void;
export declare const upperFirst: (str: string) => string;
export declare function debounce<T extends (...args: any[]) => void>(func: T, wait: number): (...args: Parameters<T>) => void;
export declare const isURL: (str: string) => boolean;
export declare const createVirtualModule: (content: string) => string;
export declare function isWebTarget(target: RsbuildTarget | RsbuildTarget[]): boolean;
export declare const isMultiCompiler: <C extends Rspack.Compiler | WebpackCompiler = Rspack.Compiler, M extends Rspack.MultiCompiler | WebpackMultiCompiler = Rspack.MultiCompiler>(compiler: C | M) => compiler is M;
export declare const onBeforeBuild: (compiler: Rspack.Compiler | Rspack.MultiCompiler, onBefore: () => Promise<any>, isWatch?: boolean) => void;
export declare const onCompileDone: (compiler: Rspack.Compiler | Rspack.MultiCompiler, onDone: (stats: Rspack.Stats | Rspack.MultiStats) => Promise<void>, MultiStatsCtor: new (stats: Rspack.Stats[]) => Rspack.MultiStats) => void;
export declare function pick<T, U extends keyof T>(obj: T, keys: ReadonlyArray<U>): Pick<T, U>;
export declare const camelCase: (input: string) => string;
export declare const prettyTime: (seconds: number) => string;
