# @rsbuild/plugin-typed-css-modules

An Rsbuild plugin to generate TypeScript declaration files for CSS Modules.

<p>
  <a href="https://npmjs.com/package/@rsbuild/plugin-typed-css-modules">
   <img src="https://img.shields.io/npm/v/@rsbuild/plugin-typed-css-modules?style=flat-square&colorA=564341&colorB=EDED91" alt="npm version" />
  </a>
  <img src="https://img.shields.io/badge/License-MIT-blue.svg?style=flat-square&colorA=564341&colorB=EDED91" alt="license" />
</p>

## Usage

Install:

```bash
npm add @rsbuild/plugin-typed-css-modules -D
```

Add plugin to your `rsbuild.config.ts`:

```ts
// rsbuild.config.ts
import { pluginTypedCSSModules } from "@rsbuild/plugin-typed-css-modules";

export default {
  plugins: [pluginTypedCSSModules()],
};
```

## Example

By adding the Typed CSS Modules plugin, Rsbuild will generate TypeScript declaration files for all CSS Modules in the project.

For example, create two files named `src/index.ts` and `src/index.module.css`:

```tsx title="src/index.ts"
import styles from "./index.module.css";

console.log(styles.pageHeader);
```

```css title="src/index.module.css"
.page-header {
  color: black;
}
```

After building, Rsbuild will generate a `src/index.module.css.d.ts` type declaration file:

```ts title="src/index.module.css.d.ts"
interface CssExports {
  "page-header": string;
  pageHeader: string;
}
declare const cssExports: CssExports;
export default cssExports;
```

Now when you open the `src/index.ts` file, you can see that the `styles` object already has an accurate type.

## Named Export

If [output.cssModules.namedExport](/config/output/css-modules#cssmodulesnamedexport) is enabled, the generated type declaration file will only include named exports.

For example:

```css title="index.module.css"
.page {
  color: black;
}
.header {
  color: white;
}
```

The generated types would be:

```ts title="src/index.module.css.d.ts"
export const page: string;
export const header: string;
```

## Configure Git

In the above example, `src/index.module.css.d.ts` is generated by compilation, you can choose to commit them to the Git repository, or you can choose to ignore them in the `.gitignore` file:

```bash
# Ignore auto generated CSS declarations
*.module.css.d.ts
*.module.sass.d.ts
*.module.scss.d.ts
*.module.less.d.ts
*.module.styl.d.ts
*.module.stylus.d.ts
```

In addition, if the generated code causes ESLint to report errors, you can also add the above configuration to the `.eslintignore` file.

## Credits

The loader was forked from [seek-oss/css-modules-typescript-loader](https://github.com/seek-oss/css-modules-typescript-loader).

## License

[MIT](./LICENSE).
