(() => {
  "use strict";
  var __webpack_modules__ = {
    601: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const loader = __nccwpck_require__(532);
      module.exports = loader.default;
      module.exports.raw = loader.raw;
    },
    532: (__unused_webpack_module, exports, __nccwpck_require__) => {
      Object.defineProperty(exports, "__esModule", { value: true });
      exports["default"] = loader;
      exports.raw = void 0;
      var _path = _interopRequireDefault(__nccwpck_require__(17));
      var _loaderUtils = __nccwpck_require__(429);
      var _schemaUtils = __nccwpck_require__(14);
      var _options = _interopRequireDefault(__nccwpck_require__(719));
      var _utils = __nccwpck_require__(913);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function loader(content) {
        const options = (0, _loaderUtils.getOptions)(this);
        (0, _schemaUtils.validate)(_options.default, options, {
          name: "File Loader",
          baseDataPath: "options",
        });
        const context = options.context || this.rootContext;
        const name = options.name || "[contenthash].[ext]";
        const url = (0, _loaderUtils.interpolateName)(this, name, {
          context,
          content,
          regExp: options.regExp,
        });
        let outputPath = url;
        if (options.outputPath) {
          if (typeof options.outputPath === "function") {
            outputPath = options.outputPath(url, this.resourcePath, context);
          } else {
            outputPath = _path.default.posix.join(options.outputPath, url);
          }
        }
        let publicPath = `__webpack_public_path__ + ${JSON.stringify(outputPath)}`;
        if (options.publicPath) {
          if (typeof options.publicPath === "function") {
            publicPath = options.publicPath(url, this.resourcePath, context);
          } else {
            publicPath = `${options.publicPath.endsWith("/") ? options.publicPath : `${options.publicPath}/`}${url}`;
          }
          publicPath = JSON.stringify(publicPath);
        }
        if (options.postTransformPublicPath) {
          publicPath = options.postTransformPublicPath(publicPath);
        }
        if (typeof options.emitFile === "undefined" || options.emitFile) {
          const assetInfo = {};
          if (typeof name === "string") {
            let normalizedName = name;
            const idx = normalizedName.indexOf("?");
            if (idx >= 0) {
              normalizedName = normalizedName.substr(0, idx);
            }
            const isImmutable =
              /\[([^:\]]+:)?(hash|contenthash)(:[^\]]+)?]/gi.test(
                normalizedName,
              );
            if (isImmutable === true) {
              assetInfo.immutable = true;
            }
          }
          assetInfo.sourceFilename = (0, _utils.normalizePath)(
            _path.default.relative(this.rootContext, this.resourcePath),
          );
          this.emitFile(outputPath, content, null, assetInfo);
        }
        const esModule =
          typeof options.esModule !== "undefined" ? options.esModule : true;
        return `${esModule ? "export default" : "module.exports ="} ${publicPath};`;
      }
      const raw = true;
      exports.raw = raw;
    },
    913: (__unused_webpack_module, exports) => {
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.normalizePath = normalizePath;
      function normalizePath(path, stripTrailing) {
        if (path === "\\" || path === "/") {
          return "/";
        }
        const len = path.length;
        if (len <= 1) {
          return path;
        }
        let prefix = "";
        if (len > 4 && path[3] === "\\") {
          const ch = path[2];
          if ((ch === "?" || ch === ".") && path.slice(0, 2) === "\\\\") {
            path = path.slice(2);
            prefix = "//";
          }
        }
        const segs = path.split(/[/\\]+/);
        if (stripTrailing !== false && segs[segs.length - 1] === "") {
          segs.pop();
        }
        return prefix + segs.join("/");
      }
    },
    14: (module) => {
      module.exports = require("./schema-utils");
    },
    429: (module) => {
      module.exports = require("loader-utils");
    },
    17: (module) => {
      module.exports = require("path");
    },
    719: (module) => {
      module.exports = JSON.parse(
        '{"additionalProperties":true,"properties":{"name":{"description":"The filename template for the target file(s) (https://github.com/webpack-contrib/file-loader#name).","anyOf":[{"type":"string"},{"instanceof":"Function"}]},"outputPath":{"description":"A filesystem path where the target file(s) will be placed (https://github.com/webpack-contrib/file-loader#outputpath).","anyOf":[{"type":"string"},{"instanceof":"Function"}]},"publicPath":{"description":"A custom public path for the target file(s) (https://github.com/webpack-contrib/file-loader#publicpath).","anyOf":[{"type":"string"},{"instanceof":"Function"}]},"postTransformPublicPath":{"description":"A custom transformation function for post-processing the publicPath (https://github.com/webpack-contrib/file-loader#posttransformpublicpath).","instanceof":"Function"},"context":{"description":"A custom file context (https://github.com/webpack-contrib/file-loader#context).","type":"string"},"emitFile":{"description":"Enables/Disables emit files (https://github.com/webpack-contrib/file-loader#emitfile).","type":"boolean"},"regExp":{"description":"A Regular Expression to one or many parts of the target file path. The capture groups can be reused in the name property using [N] placeholder (https://github.com/webpack-contrib/file-loader#regexp).","anyOf":[{"type":"string"},{"instanceof":"RegExp"}]},"esModule":{"description":"By default, file-loader generates JS modules that use the ES modules syntax.","type":"boolean"}},"type":"object"}',
      );
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = __nccwpck_require__(601);
  module.exports = __webpack_exports__;
})();
