import type { ConfigChainWithContext, RsbuildPlugin, Rspack } from '@rsbuild/core';
import type Less from '../compiled/less';
export declare const PLUGIN_LESS_NAME = "rsbuild:less";
export type LessLoaderOptions = {
    lessOptions?: Less.Options;
    additionalData?: string | ((content: string, loaderContext: Rspack.LoaderContext<LessLoaderOptions>) => string | Promise<string>);
    sourceMap?: boolean;
    webpackImporter?: boolean;
    implementation?: unknown;
};
export type PluginLessOptions = {
    /**
     * Options passed to less-loader.
     * @see https://github.com/webpack-contrib/less-loader
     */
    lessLoaderOptions?: ConfigChainWithContext<LessLoaderOptions, {
        /**
         * @deprecated
         * use `exclude` option instead.
         */
        addExcludes: (items: string | RegExp | Array<string | RegExp>) => void;
    }>;
    /**
     * Exclude some `.less` files, they will not be transformed by less-loader.
     */
    exclude?: Rspack.RuleSetCondition;
};
export declare const pluginLess: (pluginOptions?: PluginLessOptions) => RsbuildPlugin;
