(() => {
  var __webpack_modules__ = {
    701: (module, __unused_webpack_exports, __nccwpck_require__) => {
      let argv = process.argv || [],
        env = process.env;
      let isColorSupported =
        !("NO_COLOR" in env || argv.includes("--no-color")) &&
        ("FORCE_COLOR" in env ||
          argv.includes("--color") ||
          process.platform === "win32" ||
          (require != null &&
            __nccwpck_require__(224).isatty(1) &&
            env.TERM !== "dumb") ||
          "CI" in env);
      let formatter =
        (open, close, replace = open) =>
        (input) => {
          let string = "" + input;
          let index = string.indexOf(close, open.length);
          return ~index
            ? open + replaceClose(string, close, replace, index) + close
            : open + string + close;
        };
      let replaceClose = (string, close, replace, index) => {
        let result = "";
        let cursor = 0;
        do {
          result += string.substring(cursor, index) + replace;
          cursor = index + close.length;
          index = string.indexOf(close, cursor);
        } while (~index);
        return result + string.substring(cursor);
      };
      let createColors = (enabled = isColorSupported) => {
        let init = enabled ? formatter : () => String;
        return {
          isColorSupported: enabled,
          reset: init("[0m", "[0m"),
          bold: init("[1m", "[22m", "[22m[1m"),
          dim: init("[2m", "[22m", "[22m[2m"),
          italic: init("[3m", "[23m"),
          underline: init("[4m", "[24m"),
          inverse: init("[7m", "[27m"),
          hidden: init("[8m", "[28m"),
          strikethrough: init("[9m", "[29m"),
          black: init("[30m", "[39m"),
          red: init("[31m", "[39m"),
          green: init("[32m", "[39m"),
          yellow: init("[33m", "[39m"),
          blue: init("[34m", "[39m"),
          magenta: init("[35m", "[39m"),
          cyan: init("[36m", "[39m"),
          white: init("[37m", "[39m"),
          gray: init("[90m", "[39m"),
          bgBlack: init("[40m", "[49m"),
          bgRed: init("[41m", "[49m"),
          bgGreen: init("[42m", "[49m"),
          bgYellow: init("[43m", "[49m"),
          bgBlue: init("[44m", "[49m"),
          bgMagenta: init("[45m", "[49m"),
          bgCyan: init("[46m", "[49m"),
          bgWhite: init("[47m", "[49m"),
        };
      };
      module.exports = createColors();
      module.exports.createColors = createColors;
    },
    224: (module) => {
      "use strict";
      module.exports = require("tty");
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = __nccwpck_require__(701);
  module.exports = __webpack_exports__;
})();
