import type React from 'react'
import { motion } from 'framer-motion'
import { useToggle } from '@reactuses/core'
import { Navbar } from '../Navbar'
import { HistoryBar } from '../HistoryBar/HistoryBar'
import styles from './MainLayout.module.less'

interface MainLayoutProps {
  children: React.ReactNode
}

export const MainLayout: React.FC<MainLayoutProps> = ({ children }) => {
  const [isNavCollapsed, toggleNav] = useToggle(true)

  return (
    <motion.main className={styles.layoutMain}>
      <div className="w-90px h-full pl-[12px] flex items-center">
        <Navbar isCollapsed={isNavCollapsed} onToggle={toggleNav} />
        <HistoryBar isVisible={isNavCollapsed} />
      </div>
      <motion.div className={styles.layoutContent}>
        {children}
      </motion.div>
    </motion.main>
  )
}
