import type React from 'react'
import { motion } from 'framer-motion'
import { useToggle } from 'ahooks'
import { Navbar } from '../Navbar'
import { HistoryBar } from '../HistoryBar/HistoryBar'
import styles from './MainLayout.module.less'
import { useAuth } from '@/auth/AuthContext'
import { LoginModal } from '@/components/LoginModal'

interface MainLayoutProps {
  children: React.ReactNode
}

const contentVariants = {
  expanded: {
    width: '90px',
    transition: { type: 'spring', stiffness: 300, damping: 30 },
  },
  shrunk: {
    width: '340px',
    transition: { type: 'spring', stiffness: 300, damping: 30 },
  },
}

export const MainLayout: React.FC<MainLayoutProps> = ({ children }) => {
  const { showLoginModal, toggleLoginModal } = useAuth()
  const [isHistoryVisible, { toggle }] = useToggle()
  return (
    <motion.main className={styles.layoutMain}>
      <motion.div
        animate={isHistoryVisible ? 'shrunk' : 'expanded'}
        variants={contentVariants}
        className={`h-full pl-[12px] flex items-center ${isHistoryVisible ? 'w-[340px]' : 'w-[90px]'}`}
      >
        <Navbar isCollapsed={isHistoryVisible} onToggle={toggle} />
        <HistoryBar isVisible={isHistoryVisible} />
      </motion.div>
      <motion.div
        className={styles.layoutContent}
      >
        {children}
      </motion.div>

      <LoginModal isOpen={showLoginModal} onClose={toggleLoginModal} />
    </motion.main>
  )
}
