import React, { useEffect, useState } from 'react'
import ReactMarkdown from 'react-markdown'
import rehypeRaw from 'rehype-raw'
import rehypeSanitize from 'rehype-sanitize'
import remarkGfm from 'remark-gfm'
import type { Answer } from '@/types/chat'

interface ChatAnswerParserProps {
  answer: Answer
}

export const ChatAnswerParser: React.FC<ChatAnswerParserProps> = ({ answer }) => {
  const [displayedText, setDisplayedText] = useState('')
  const [currentIndex, setCurrentIndex] = useState(0)

  useEffect(() => {
    if (currentIndex < answer.answer.length) {
      const timer = setTimeout(() => {
        setDisplayedText(answer.answer.slice(0, currentIndex + 1))
        setCurrentIndex(prevIndex => prevIndex + 1)
      }, 30) // 调整此值以改变打字速度

      return () => clearTimeout(timer)
    }
  }, [answer, currentIndex])

  return (
    <div className="answerParser">
      <ReactMarkdown
        rehypePlugins={[rehypeRaw, rehypeSanitize]}
        remarkPlugins={[remarkGfm]}
        className="markdown-content"
      >
        {displayedText}
      </ReactMarkdown>
    </div>
  )
}
