import type Connect from '../../compiled/connect';
import type { HtmlFallback, RequestHandler as Middleware, Rspack } from '../types';
export declare const faviconFallbackMiddleware: Middleware;
export declare const getRequestLoggerMiddleware: () => Promise<Connect.NextHandleFunction>;
export declare const notFoundMiddleware: Middleware;
/**
 * Support access HTML without suffix
 */
export declare const getHtmlCompletionMiddleware: (params: {
    distPath: string;
    callback: Middleware;
    outputFileSystem: Rspack.OutputFileSystem;
}) => Middleware;
/**
 * support HTML fallback in some edge cases
 */
export declare const getHtmlFallbackMiddleware: (params: {
    distPath: string;
    callback: Middleware;
    htmlFallback?: HtmlFallback;
    outputFileSystem: Rspack.OutputFileSystem;
}) => Middleware;
