import type { IncomingMessage } from 'node:http';
import type { Socket } from 'node:net';
import type { InternalContext, NormalizedConfig, OutputStructure, PrintUrls, Routes, RsbuildEntry, Rspack } from '../types';
/**
 * It used to subscribe http upgrade event
 */
export type UpgradeEvent = (req: IncomingMessage, socket: Socket, head: any) => void;
export type StartServerResult = {
    urls: string[];
    port: number;
    server: {
        close: () => Promise<void>;
    };
};
export declare const normalizeUrl: (url: string) => string;
export declare const getRoutes: (context: InternalContext) => Routes;
export declare const formatRoutes: (entry: RsbuildEntry, prefix: string | undefined, outputStructure: OutputStructure | undefined) => Routes;
export declare function printServerURLs({ urls: originalUrls, port, routes, protocol, printUrls, }: {
    urls: Array<{
        url: string;
        label: string;
    }>;
    port: number;
    routes: Routes;
    protocol: string;
    printUrls?: PrintUrls;
}): string | null;
/**
 * Get available free port.
 * @param port - Current port want to use.
 * @param tryLimits - Maximum number of retries.
 * @param strictPort - Whether to throw an error when the port is occupied.
 * @returns Available port number.
 */
export declare const getPort: ({ host, port, strictPort, tryLimits, silent, }: {
    host: string;
    port: string | number;
    strictPort: boolean;
    tryLimits?: number;
    silent?: boolean;
}) => Promise<number>;
export declare const getServerConfig: ({ config, getPortSilently, }: {
    config: NormalizedConfig;
    getPortSilently?: boolean;
}) => Promise<{
    port: number;
    host: string;
    https: boolean;
}>;
type AddressUrl = {
    label: string;
    url: string;
};
export declare const getAddressUrls: ({ protocol, port, host, }: {
    protocol?: string;
    port: number;
    host?: string;
}) => AddressUrl[];
export declare const getCompilationName: (compiler: Rspack.Compiler | Rspack.Compilation) => string;
export {};
