import RspackChain from '../compiled/rspack-chain';
import type { InternalContext, ModifyBundlerChainUtils, RspackConfig } from './types';
export declare function getBundlerChain(): RspackChain;
export declare function modifyBundlerChain(context: InternalContext, utils: ModifyBundlerChainUtils): Promise<RspackChain>;
export declare function chainToConfig(chain: RspackChain): RspackConfig;
export declare const CHAIN_ID: {
    /** Predefined rules */
    readonly RULE: {
        /** Rule for .mjs */
        readonly MJS: "mjs";
        /** Rule for fonts */
        readonly FONT: "font";
        /** Rule for images */
        readonly IMAGE: "image";
        /** Rule for media */
        readonly MEDIA: "media";
        /** Rule for js */
        readonly JS: "js";
        /** Rule for data uri encoded javascript */
        readonly JS_DATA_URI: "js-data-uri";
        /** Rule for ts */
        readonly TS: "ts";
        /** Rule for css */
        readonly CSS: "css";
        /** Rule for less */
        readonly LESS: "less";
        /** Rule for sass */
        readonly SASS: "sass";
        /** Rule for stylus */
        readonly STYLUS: "stylus";
        /** Rule for svg */
        readonly SVG: "svg";
        /** Rule for pug */
        readonly PUG: "pug";
        /** Rule for Vue */
        readonly VUE: "vue";
        /** Rule for yaml */
        readonly YAML: "yaml";
        /** Rule for wasm */
        readonly WASM: "wasm";
        /** Rule for svelte */
        readonly SVELTE: "svelte";
    };
    /** Predefined rule groups */
    readonly ONE_OF: {
        readonly SVG: "svg";
        readonly SVG_URL: "svg-asset-url";
        readonly SVG_ASSET: "svg-asset";
        readonly SVG_REACT: "svg-react";
        readonly SVG_INLINE: "svg-asset-inline";
    };
    /** Predefined loaders */
    readonly USE: {
        /** ts-loader */
        readonly TS: "ts";
        /** css-loader */
        readonly CSS: "css";
        /** sass-loader */
        readonly SASS: "sass";
        /** less-loader */
        readonly LESS: "less";
        /** stylus-loader */
        readonly STYLUS: "stylus";
        /** url-loader */
        readonly URL: "url";
        /** pug-loader */
        readonly PUG: "pug";
        /** vue-loader */
        readonly VUE: "vue";
        /** swc-loader */
        readonly SWC: "swc";
        /** svgr */
        readonly SVGR: "svgr";
        /** yaml-loader */
        readonly YAML: "yaml";
        /** babel-loader */
        readonly BABEL: "babel";
        /** style-loader */
        readonly STYLE: "style-loader";
        /** svelte-loader */
        readonly SVELTE: "svelte";
        /** postcss-loader */
        readonly POSTCSS: "postcss";
        /** lightningcss-loader */
        readonly LIGHTNINGCSS: "lightningcss";
        /** ignore-css-loader */
        readonly IGNORE_CSS: "ignore-css";
        /** css-modules-typescript-loader */
        readonly CSS_MODULES_TS: "css-modules-typescript";
        /** CssExtractRspackPlugin.loader */
        readonly MINI_CSS_EXTRACT: "mini-css-extract";
        /** resolve-url-loader */
        readonly RESOLVE_URL: "resolve-url-loader";
    };
    /** Predefined plugins */
    readonly PLUGIN: {
        /** HotModuleReplacementPlugin */
        readonly HMR: "hmr";
        /** CopyRspackPlugin */
        readonly COPY: "copy";
        /** HtmlRspackPlugin */
        readonly HTML: "html";
        /** ESLintWebpackPlugin */
        readonly ESLINT: "eslint";
        /** DefinePlugin */
        readonly DEFINE: "define";
        /** ProgressPlugin */
        readonly PROGRESS: "progress";
        /** WebpackManifestPlugin */
        readonly MANIFEST: "webpack-manifest";
        /** ForkTsCheckerWebpackPlugin */
        readonly TS_CHECKER: "ts-checker";
        /** WebpackBundleAnalyzer */
        readonly BUNDLE_ANALYZER: "bundle-analyze";
        /** ModuleFederationPlugin */
        readonly MODULE_FEDERATION: "module-federation";
        /** HtmlBasicPlugin */
        readonly HTML_BASIC: "html-basic-plugin";
        /** htmlPrefetchPlugin */
        readonly HTML_PREFETCH: "html-prefetch-plugin";
        /** htmlPreloadPlugin */
        readonly HTML_PRELOAD: "html-preload-plugin";
        /** CssExtractRspackPlugin */
        readonly MINI_CSS_EXTRACT: "mini-css-extract";
        /** VueLoaderPlugin */
        readonly VUE_LOADER_PLUGIN: "vue-loader-plugin";
        /** ReactFastRefreshPlugin */
        readonly REACT_FAST_REFRESH: "react-fast-refresh";
        /** ProvidePlugin for node polyfill */
        readonly NODE_POLYFILL_PROVIDE: "node-polyfill-provide";
        /** WebpackSRIPlugin */
        readonly SUBRESOURCE_INTEGRITY: "subresource-integrity";
        /** AutoSetRootFontSizePlugin */
        readonly AUTO_SET_ROOT_SIZE: "auto-set-root-size";
    };
    /** Predefined minimizers */
    readonly MINIMIZER: {
        /** SwcJsMinimizerRspackPlugin */
        readonly JS: "js";
        /** LightningCssMinimizerRspackPlugin */
        readonly CSS: "css";
    };
    /** Predefined resolve plugins */
    readonly RESOLVE_PLUGIN: {
        /** TsConfigPathsPlugin */
        readonly TS_CONFIG_PATHS: "ts-config-paths";
    };
};
export type ChainIdentifier = typeof CHAIN_ID;
