// src/components/FilePreviewModal/PdfPreview.tsx
import React from 'react'

interface PdfPreviewProps {
  src: string
  className?: string
  onLoaded?: () => void
  onError?: (error: any) => void
}

export const PdfPreview: React.FC<PdfPreviewProps> = ({ src, className = '', onLoaded, onError }) => {
  const handleLoad = () => {
    onLoaded?.()
  }

  const handleError = (_e: React.SyntheticEvent) => {
    onError?.(new Error('PDF加载失败'))
  }

  // 完整的PDF参数配置
  // toolbar=0 隐藏工具栏 0=隐藏, 1=显示
  // navpanes=0 隐藏导航面板 0=隐藏, 1=显示
  // scrollbar=0 隐藏滚动条 0=隐藏, 1=显示
  // statusbar=0 隐藏状态栏 0=隐藏, 1=显示
  // messages=0 隐藏消息栏 0=隐藏, 1=显示
  // view=FitH 设置视图模式 FitH=水平适应, FitV=垂直适应
  // zoom=page-width 设置缩放模式 page-width=页面宽度
  const pdfUrl = `${src}#toolbar=0&navpanes=0&scrollbar=0&view=FitH&statusbar=0&messages=0&zoom=page-width`

  return (
    <div className={`${className} h-full flex flex-col`}>
      <div className="flex-grow overflow-hidden bg-gray-100">
        <embed
          src={pdfUrl}
          type="application/pdf"
          className="w-full h-full border-0"
          onLoad={handleLoad}
          onError={handleError}
        />
      </div>
    </div>
  )
}
