import type React from 'react'
import { motion } from 'framer-motion'
import styles from './Navbar.module.less'
import { NavBarItem } from './components/NavBarItem'
import Logo from '@/assets/svg/logo.svg?react'
import AddNewChat from '@/assets/svg/addNewChat.svg?react'
import HistoryChat from '@/assets/svg/historyChat.svg?react'
import Collect from '@/assets/svg/collect.svg?react'
import Tools from '@/assets/svg/tools.svg?react'

interface NavbarProps {
  isCollapsed: boolean
  onToggle: () => void
}

const NAV_BAR_ITEMS = [
  { icon: Logo, label: '', key: 'logo' },
  { icon: '', label: '', key: 'line1' },
  { icon: AddNewChat, label: '新建对话', key: 'add' },
  { icon: HistoryChat, label: '历史对话', key: 'history' },
  { icon: Collect, label: '收藏', key: 'collect' },
  { icon: '', label: '', key: 'line2' },
  { icon: Tools, label: '工具', key: 'tools' },
]
// onToggle isCollapsed
export const Navbar: React.FC<NavbarProps> = () => {
  return (
    <motion.nav className="w-0 sm:w-[90px]  flex-shrink-0 flex flex-col items-center justify-center">
      <motion.div className={`${styles.layoutNavBarAgent} sm:flex hidden w-[64px] bg-white gap-[28px]`}>
        {NAV_BAR_ITEMS.map((item) => {
          return (
            <NavBarItem icon={item.icon} label={item.label} key={item.key} />
          )
        })}
      </motion.div>
    </motion.nav>
  )
}
