import type React from 'react'
import { motion } from 'framer-motion'
import styles from './Home.module.less'
import { QuestionList } from './components/QuestionList'
import { WelcomeWord } from './components/WelcomeWord'
import { Slogan } from './components/Slogan/Slogan'
import HomeIcon1 from '@/assets/homeIcon1.png'
import HomeIcon2 from '@/assets/homeIcon2.png'
import { GradientBackground } from '@/components/GradientBackground'
import { ChatEditor } from '@/components/ChatEditor'
import { RECOMMEND_QUESTIONS_OTHER, RECOMMEND_QUESTIONS_PRODUCT } from '@/config/recommendQuestion'
import { createConversation } from '@/store/conversationSlice'
import { useAppDispatch } from '@/store/hook'

function getAnimationProps(delay: number) {
  return {
    variants: {
      hidden: {
        opacity: 0,
        y: 50,
        scale: 0.9,
        rotateX: -6,
      },
      visible: {
        opacity: 1,
        y: 0,
        scale: 1,
        rotateX: 0,
        transition: {
          duration: 0.4,
          delay: delay * 0.1,
          ease: [0.25, 0.1, 0.25, 1],
        },
      },
    },
    initial: 'hidden',
    animate: 'visible',
  }
}

export const Home: React.FC = () => {
  const dispatch = useAppDispatch()

  const handleCreateConversation = (question: string) => {
    dispatch(createConversation({
      conversationData: {},
      shouldNavigate: true,
      shouldSendQuestion: question,
    }))
  }
  return (
    <div className={styles.homePage}>
      <GradientBackground />
      <div className="h-full w-full">
        <div className="box flex flex-col h-full w-full">
          <div className="flex-1 sm:flex items-center overflow-y-scroll pt-[32px] scrollbar-hide sm:overflow-hidden">
            <div className="w-full">
              <div className="px-[24px] pb-[24px] sm:px-0">
                {/* slogan */}
                <Slogan />

                {/* 欢迎语 */}
                <div className="gap-[20px] flex justify-center flex-row flex-wrap  mt-[42px] sm:mt-[62px] lg:mt-[112px]">

                  <motion.div className="w-full hidden sm:block sm:w-auto" {...getAnimationProps(1)}><WelcomeWord /></motion.div>
                  <motion.div className="w-full sm:w-auto" {...getAnimationProps(2)}><QuestionList questions={RECOMMEND_QUESTIONS_PRODUCT} dotColor="#D4CCFF" title="产品问答" iconImg={HomeIcon1} /></motion.div>
                  <motion.div className="w-full sm:w-auto" {...getAnimationProps(3)}><QuestionList questions={RECOMMEND_QUESTIONS_OTHER} dotColor="#CBECFF" title="其他问答" iconImg={HomeIcon2} /></motion.div>
                </div>
              </div>
            </div>
            {/* pt-[42px] sm:pt-[80px] lg:pt-[180px]  */}
            {/* <Virtuoso
              style={{ height: '100%' }}
              className="scrollbar-hide"
              totalCount={1}
              itemContent={() => (

              )} */}
            {/* /> */}
          </div>
          <div className="box-border px-[0] mx-auto iptContainer w-full  max-w-[912px] flex-shrink-0 sm:px-0 pb-[18px]">
            <ChatEditor onSubmit={handleCreateConversation} placeholders={RECOMMEND_QUESTIONS_OTHER} />
            <div className="w-full text-center mt-[12px] text-[#3333334d] text-[12px]">
              内容由AI模型生成，其准确性和完整性无法保证，仅供参考
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
