import React from 'react'
import { motion } from 'framer-motion'
import { Button, Tooltip } from '@nextui-org/react'
import { useLocation, useNavigate } from 'react-router-dom'
import { NavBarDivider } from '../NavBarDivider'
import styles from './NavBarItem.module.less'
import Logo from '@/assets/svg/logo.svg?react'
import Logo3 from '@/assets/svg/logo3.svg?react'
import { isMobile } from '@/utils'

interface NavBarItemProps {
  onClick: (key: string) => void
  icon: React.FunctionComponent<React.SVGProps<SVGSVGElement>> | string
  label: string
  type: string
  isHistoryVisible: boolean
}
export const NavBarItem: React.FC<NavBarItemProps> = ({ isHistoryVisible, onClick, icon, label, type }) => {
  const navigate = useNavigate()
  const location = useLocation()

  const handleClickLogo = () => {
    if (isMobile()) {
      onClick('logo')
    }
    else {
      navigate('/')
    }
  }
  if (label === '' && icon === '') {
    return <NavBarDivider />
  }
  if (label === '' && icon !== '') {
    return (
      <motion.div
        whileHover={{ scale: 1.05 }}
        transition={{ type: 'spring', stiffness: 400, damping: 10 }}
        className="nav-logo cursor-pointer"
        onClick={handleClickLogo}
      >
        {type === 'logo' && <Logo />}
        {type === 'logo3' && <Logo3 />}
      </motion.div>
    )
  }

  const handleActive = () => {
    if (type === 'history' && isHistoryVisible) {
      return true
    }
    if (type === 'tools' && location.pathname === '/tools') {
      return true
    }
    if (type === 'collect' && location.pathname === '/collect') {
      return true
    }
  }

  return (
    <motion.div className={`${styles.NavBarItem}`}>
      <div className={`${styles.icon}`}>
        <Tooltip color="foreground" content={label} placement="right">
          <Button className={handleActive() ? 'bg-[#e4e4e5]' : ''} onClick={() => onClick(type)} variant="light" isIconOnly aria-label="Like">
            {React.createElement(icon)}
          </Button>
        </Tooltip>
      </div>
      {/* <div className={styles.label}>{label}</div> */}
    </motion.div>
  )
}
