export interface Attachment {
  type: string
  name: string
  description: string
}

export interface Answer {
  isShow: boolean
  answer: string
  collectionFlag?: boolean
  feedbackStatus?: string
  groupId?: string
  question?: string
  recordId?: string
  terminateFlag?: boolean
  toolName?: string
  attachmentList: Attachment[]
}

export interface OriginalRecord {
  answer?: string
  groupId?: string
  question?: string
  answerList: Answer[]
  productCode?: string
  qaTime?: string
}

export type ChatRecordRole = 'system' | 'user' | 'ai'

export interface ChatRecord extends OriginalRecord {
  role: ChatRecordRole
}

export interface ChatState {
  records: ChatRecord[]
  isLoading: boolean
  error: string | null
}
