import { Avatar, Spinner } from '@nextui-org/react'
import { motion } from 'framer-motion'
import { ChatAnswerShower } from './ChatAnswerShower'
import { ChatAnswerParser } from './ChatAnswerParser'
import type { ChatRecord } from '@/types/chat'
import AvatarBot from '@/assets/avatarBot.png'

interface ChatAnswerBoxProps {
  record: ChatRecord
  showIndex: number
  isLastAnswer: boolean
  index: number
}

export const ChatAnswerBox: React.FC<ChatAnswerBoxProps> = ({ record, showIndex }) => {
  return (
    <div>
      {record.answerList.map((item, index) => {
        return (
          index === showIndex && (
            <div className="chatItemBotContainer w-full" key={`${item.recordId}-${index}`}>
              <div className="flex">
                <Avatar className="flex-shrink-0" src={AvatarBot} />
                <motion.div
                  className="ml-[20px] bg-white rounded-[20px] box-border px-[24px] py-[20px]"
                >
                  {item.answer && (
                    <div className="content">
                      {item.isShow && <ChatAnswerShower answer={item} />}
                      {!item.isShow && <ChatAnswerParser answer={item} />}
                    </div>
                  )}
                  {!item.answer && (
                    <Spinner size="sm" />
                  )}
                </motion.div>
                <div className="w-[130px]"></div>
              </div>
              <div className="h-[32px] w-full"></div>
            </div>
          )
        )
      })}
    </div>
  )
}
