/**
 * 完整的数据结构示例
 * 基于图片中的JSON数据整理
 */
import type { Answer, OriginalRecord } from './chat'

/**
 * 邮件卡片数据示例
 * 对应图片中的 card-email 类型
 */
export const emailCardExample: Answer = {
  recordId: '2009500257743388673',
  groupId: '2009238981179711490',
  conversationId: '2009238981179711490',
  busiType: '01',
  ordType: '01',
  question: '给张三发送邮件 邮件内容为今天天气不错,标题为天气很好',
  answer: '邮件内容解析成功',
  endAnswer: true,
  endAnswerFlag: true,
  endCardFlag: true,
  isShow: true,
  cardList: [
    {
      type: 'card-email',
      name: '',
      url: '',
      description: '发送邮件',
      content: {
        docList: [],
        description: '发送邮件',
        productList: [],
        url: '',
        title: '天气很好',
        mailMsg: '张三,您好!\n\n今天天气不错,希望您也能享受这美好的时光。\n\n祝好!',
        receiver: '张三',
        emailList: [
          {
            sendName: '张三',
            emailAddr: '12345@qq.com',
          },
          {
            sendName: '张三',
            emailAddr: '1123@qq.com',
          },
        ],
      },
    },
  ],
  extra: {
    executorName: '@发送邮件',
    optimizedQuestion: '给张三发送邮件,邮件内容为今天天气不错,标题为天气很好',
    executorBeanName: 'sendEmailExecutor',
    step: {
      step: 'finished',
      message: '回答完成',
    },
  },
  step: {
    step: 'finished',
    message: '回答完成',
  },
  qaTime: 1767937177564,
}

/**
 * 完整的聊天记录示例
 */
export const chatRecordExample: OriginalRecord = {
  question: '给张三发送邮件 邮件内容为今天天气不错,标题为天气很好',
  groupId: '2009238981179711490',
  qaTime: '1767937177564',
  answerList: [emailCardExample],
}

/**
 * 数据结构说明：
 *
 * Answer 接口主要字段：
 * - recordId: 记录ID
 * - groupId: 分组ID
 * - conversationId: 会话ID
 * - busiType: 业务类型
 * - ordType: 订单类型
 * - question: 用户问题
 * - answer: AI回答内容
 * - endAnswer: 是否结束回答（布尔值）
 * - endAnswerFlag: 是否结束回答标志（布尔值）
 * - endCardFlag: 是否结束卡片标志（布尔值）
 * - cardList: 卡片列表，包含不同类型的附件
 * - extra: 额外信息，包含执行器相关信息
 * - step: 步骤信息，包含当前步骤和消息
 * - qaTime: 问答时间戳
 *
 * Attachment (cardList中的项) 主要字段：
 * - type: 卡片类型，如 'card-email', 'card-nav', 'card-detail' 等
 * - description: 卡片描述
 * - content: 卡片内容，根据类型不同包含不同字段
 *   - 对于 card-email 类型：
 *     - title: 邮件标题
 *     - mailMsg: 邮件正文内容
 *     - receiver: 收件人姓名
 *     - emailList: 收件人邮箱列表
 *
 * AnswerExtra 接口字段：
 * - executorName: 执行器名称
 * - optimizedQuestion: 优化后的问题
 * - executorBeanName: 执行器Bean名称
 * - step: 步骤信息
 */
