import React, { useEffect } from 'react'
import { useLocation } from 'react-router-dom'
import { clearCurrentConversation } from '@/store/conversationSlice'
import { useAppDispatch } from '@/store/hook'

export function withRouteChangeHandler(WrappedComponent: React.ComponentType) {
  return (props: any) => {
    const location = useLocation()
    const dispatch = useAppDispatch()

    useEffect(() => {
      if (location.pathname === '/') {
        dispatch(clearCurrentConversation())
      }
      // 这里可以添加其他路由相关的逻辑
    }, [location, dispatch])

    return <WrappedComponent {...props} />
  }
}
