import { formatMarkdown } from './markdownFormatter'
import { ChatAnswerAttachment } from './ChatAnswerAttchment'
import { ChatAnswerOperate } from './ChatAnswerOperate'
import type { Answer } from '@/types/chat'
import { MarkdownDetail } from '@/components/MarkdownDetail'

interface ChatAnswerShowerProps {
  answer: Answer
  isLastAnswer: boolean
  onSubmitQuestion: (question: string) => void
}

export const ChatAnswerShower: React.FC<ChatAnswerShowerProps> = ({ answer, isLastAnswer, onSubmitQuestion }) => {
  const hideOperate = (answer.attachmentList || []).some(attachment => attachment.type === 'box')
  return (
    <div className="answerShower">
      {answer.answer && (
        <div className={answer.attachmentList?.length ? 'mb-[20px]' : ''}>
          <MarkdownDetail>
            {formatMarkdown(answer.answer || '')}
          </MarkdownDetail>
        </div>
      )}
      {answer.attachmentList && answer.attachmentList?.length !== 0 && <ChatAnswerAttachment onSubmitQuestion={onSubmitQuestion} isLastAnswer={isLastAnswer} answer={answer} />}
      {!hideOperate && <ChatAnswerOperate answer={answer} />}
    </div>
  )
}
