import type React from 'react'
import { motion } from 'framer-motion'
import styles from './Navbar.module.less'
import { NavBarItem } from './components/NavBarItem'
import Logo from '@/assets/svg/logo.svg?react'
import AddNewChat from '@/assets/svg/addNewChat.svg?react'
import HistoryChat from '@/assets/svg/historyChat.svg?react'
import Collect from '@/assets/svg/collect.svg?react'
import Tools from '@/assets/svg/tools.svg?react'

interface NavbarProps {
  isCollapsed: boolean
  onToggle: () => void
}

const NAV_BAR_ITEMS = [
  { icon: Logo, label: '', key: 'logo' },
  { icon: '', label: '', key: 'line1' },
  { icon: AddNewChat, label: '新建对话', key: 'add' },
  { icon: HistoryChat, label: '历史对话', key: 'history' },
  { icon: Collect, label: '收藏', key: 'collect' },
  { icon: '', label: '', key: 'line2' },
  { icon: Tools, label: '工具', key: 'tools' },
]
// onToggle
export const Navbar: React.FC<NavbarProps> = ({ isCollapsed }) => {
  return (
    <motion.nav className={`${styles.layoutNav} ${isCollapsed ? styles.collapsed : ''}`}>
      <motion.div className={styles.layoutNavBar}>
        <motion.div className={`${styles.layoutNavBarAgent} bg-white gap-[32px]`}>
          {NAV_BAR_ITEMS.map((item) => {
            return (
              <NavBarItem icon={item.icon} label={item.label} key={item.key} />
            )
          })}
        </motion.div>
      </motion.div>
      <motion.div className={styles.layoutNavHot}></motion.div>
    </motion.nav>
  )
}
