import type React from 'react'
import { Virtuoso } from 'react-virtuoso'
import { useEffect } from 'react'
import styles from './Home.module.less'
import { QuestionList } from './components/QuestionList'
import { WelcomeWord } from './components/WelcomeWord'
import { Slogan } from './components/Slogan/Slogan'
import HomeIcon1 from '@/assets/homeIcon1.png'
import HomeIcon2 from '@/assets/homeIcon2.png'
import { GradientBackground } from '@/components/GradientBackground'
import { ChatEditor } from '@/components/ChatEditor'
import { RECOMMEND_QUESTIONS_OTHER, RECOMMEND_QUESTIONS_PRODUCT } from '@/config/recommendQuestion'

export const Home: React.FC = () => {
  const placeholders = [
    '推荐几款60周岁还能投的医疗？',
    '有哪些养老保险可以无脑入？',
    '今年头部的保险公司有哪些好的产品？',
    '直接开始问吧！',
    '保险公司偿付能力在哪里可以看？',
  ]

  useEffect(() => {
    // getRecommendQuestionList()
  }, [])

  return (
    <div className={styles.homePage}>
      <GradientBackground />
      <div className="h-full w-full">
        <div className="box flex flex-col h-full w-full">
          <div className="flex-1">
            <Virtuoso
              style={{ height: '100%' }}
              totalCount={1}
              itemContent={() => (
                <div className="px-[24px] pb-[24px] pt-[42px] sm:pt-[80px] lg:pt-[180px] sm:px-0">
                  {/* slogan */}
                  <Slogan />

                  {/* 欢迎语 */}
                  <div className="gap-[20px] flex justify-center flex-row flex-wrap  mt-[42px] sm:mt-[62px] lg:mt-[112px]">
                    <WelcomeWord />
                    <QuestionList questions={RECOMMEND_QUESTIONS_PRODUCT} dotColor="#D4CCFF" title="产品问答" iconImg={HomeIcon1} />
                    <QuestionList questions={RECOMMEND_QUESTIONS_OTHER} dotColor="#CBECFF" title="其他问答" iconImg={HomeIcon2} />
                  </div>
                </div>
              )}
            />
          </div>
          <div className="box-border px-[0] mx-auto iptContainer w-full  max-w-[1000px] flex-shrink-0 sm:px-0 pb-[18px]">
            <ChatEditor placeholders={placeholders} />
            <div className="w-full text-center mt-[20px] text-[#3333334d] text-[12px]">
              内容由AI模型生成，其准确性和完整性无法保证，仅供参考
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
