import { Virtuoso } from 'react-virtuoso'
import { motion } from 'framer-motion'
import styles from './Tools.module.less'
import { Slogan } from './components/Slogan/Slogan'
import { GradientBackground } from '@/components/GradientBackground'

function getAnimationProps(delay: number) {
  return {
    variants: {
      hidden: {
        opacity: 0,
        y: 50,
        scale: 0.9,
        rotateX: -6,
      },
      visible: {
        opacity: 1,
        y: 0,
        scale: 1,
        rotateX: 0,
        transition: {
          duration: 0.4,
          delay: delay * 0.1,
          ease: [0.25, 0.1, 0.25, 1],
        },
      },
    },
    initial: 'hidden',
    animate: 'visible',
  }
}

export const Tools: React.FC = () => {
  return (
    <div className={styles.toolsPage}>
      <GradientBackground />
      <div className="h-full w-full">
        <div className="box flex flex-col h-full w-full">
          <div className="flex-1">
            <Virtuoso
              style={{ height: '100%' }}
              totalCount={1}
              itemContent={() => (
                <div className="px-[24px] pb-[24px] pt-[42px] sm:pt-[80px] lg:pt-[180px] sm:px-0">
                  <Slogan />
                  <div>
                    <div className="max-w-[1000px] flex mx-auto mt-[64px] text-18px text-[#5AA9D0] font-light">全部工具</div>
                    <div className="max-w-[1000px] mx-auto gap-[20px] flex flex-col flex-wrap  mt-[22px] sm:flex-row">
                      <motion.div className=" rounded-[20px] bg-[#fff] flex-1 h-[100px] p-[24px]" {...getAnimationProps(1)}>工具1</motion.div>
                      <motion.div className=" rounded-[20px] bg-[#fff] flex-1 h-[100px] p-[24px]" {...getAnimationProps(2)}>工具2</motion.div>
                      <motion.div className=" rounded-[20px] bg-[#fff] flex-1 h-[100px] p-[24px]" {...getAnimationProps(3)}>工具3</motion.div>
                    </div>
                  </div>
                </div>
              )}
            />
          </div>
        </div>
      </div>
    </div>
  )
}
