import React from 'react'
import ReactDOM from 'react-dom/client'
import { HeroUIProvider } from '@heroui/react'
import App from './App'
import './styles/index.less'
import 'github-markdown-css/github-markdown.css'
import 'react-photo-view/dist/react-photo-view.css'

const rootEl = document.getElementById('root')

document.documentElement.classList.add('light')

// 添加 Object.hasOwn 的 polyfill
if (!Object.hasOwn) {
  Object.defineProperty(Object, 'hasOwn', {
    value(object: any, property: PropertyKey) {
      if (object == null) {
        throw new TypeError('Cannot convert undefined or null to object')
      }
      return Object.prototype.hasOwnProperty.call(Object(object), property)
    },
    configurable: true,
    enumerable: false,
    writable: true,
  })
}
// printText2Console()

if (rootEl) {
  const root = ReactDOM.createRoot(rootEl)
  root.render(
    <React.StrictMode>
      <HeroUIProvider className="h-full">
        <App />
      </HeroUIProvider>
    </React.StrictMode>,
  )
}
