import { Virtuoso } from 'react-virtuoso'
import { motion } from 'framer-motion'
import styles from './Tools.module.less'
import { Slogan } from './components/Slogan/Slogan'
import { GradientBackground } from '@/components/GradientBackground'
import ToolsNav from '@/assets/tools-nav.png'
import ToolsCalculation from '@/assets/tools-calculation.png'
import ToolsDetail from '@/assets/tools-detail.png'
import useToast from '@/hooks/useToast'
import ShineBorder from '@/components/ShineBorder'

function getAnimationProps(delay: number) {
  return {
    variants: {
      hidden: {
        opacity: 0,
        y: 50,
        scale: 0.9,
        rotateX: -6,
      },
      visible: {
        opacity: 1,
        y: 0,
        scale: 1,
        rotateX: 0,
        transition: {
          duration: 0.4,
          delay: delay * 0.1,
          ease: [0.25, 0.1, 0.25, 1],
        },
      },
    },
    initial: 'hidden',
    animate: 'visible',
  }
}

export const Tools: React.FC = () => {
  const tools = [
    { name: '产品试算', desc: '支持保险产品保费测算', icon: ToolsCalculation },
    { name: '净值查询', desc: '支持商养产品净值查询', icon: ToolsDetail },
    { name: '商养收益计算器', desc: '查看商养产品详情信息', icon: ToolsNav },
  ]
  const showToast = useToast()
  const handleClickToolItem = () => {
    showToast('策马加鞭紧急开发中！', 'default', {
      icon: '🚧',
    })
  }
  return (
    <div className={styles.toolsPage}>
      <GradientBackground />
      <div className="h-full w-full">
        <div className="box flex flex-col h-full w-full">
          <div className="flex-1">
            <Virtuoso
              style={{ height: '100%' }}
              totalCount={1}
              itemContent={() => (
                <div className="px-[24px] pb-[24px] pt-[42px] sm:pt-[80px] lg:pt-[180px] sm:px-0">
                  <Slogan />
                  <div>
                    <div className="max-w-[1000px] flex mx-auto mt-[64px] text-18px text-[#5AA9D0] font-light">全部工具</div>
                    <div className="max-w-[1000px] mx-auto gap-[20px] flex flex-col flex-wrap  mt-[22px] sm:flex-row">
                      {tools.map((item, index) => (
                        <motion.div className="flex-1" key={index} onClick={handleClickToolItem} {...getAnimationProps(index + 1)}>
                          <ShineBorder
                            borderRadius={20}
                            className="rounded-[20px] bg-[#fff] flex-1 h-[100px] p-[24px] cursor-pointer"
                            innerClassName="flex items-center"
                          >
                            <img className="w-[52px]" src={item.icon} alt="" />
                            <div className="ml-[20px]">
                              <h3 className="font-bold">{item.name}</h3>
                              <p className="text-[14px] text-[#27353CCC] mt-[3px]">{item.desc}</p>
                            </div>
                          </ShineBorder>
                        </motion.div>
                      )) }
                    </div>
                  </div>
                </div>
              )}
            />
          </div>
        </div>
      </div>
    </div>
  )
}
