import { Link } from '@nextui-org/react'
import type { Answer } from '@/types/chat'
import AnswerProDetailIcon from '@/assets/svg/answerProDetail.svg?react'

interface ChatAnswerAttachmentProps {
  answer: Answer
}
export const ChatAnswerAttachment: React.FC<ChatAnswerAttachmentProps> = ({ answer }) => {
  return (
    <div className="attachmentList flex flex-col gap-[20px] mt-[20px]">
      {answer.attachmentList && answer.attachmentList.map((attachment, index) => (
        <div key={`${attachment.type}_${index}`}>

          {/* 附件：product-detail */}
          {attachment.type === 'product-detail' && (
            <div className="bg-[#29B6FD0A] text-[14px] text-primary py-[4px] px-[16px] w-fit flex items-center">
              <AnswerProDetailIcon />
              {/* <span className="ml-[6px]">{attachment.name}</span> */}
              <div className="ml-[6px] w-[120px] sm:w-full text-nowrap text-ellipsis overflow-hidden">
                {attachment.name}
              </div>
            </div>
          )}

          {/* 附件：引用文件 */}
          {attachment.type === 'reference' && attachment.content.docList.length !== 0 && (
            <div>
              <p className="text-[14px] text-[#8D9795] mb-[12px]">
                已为您找到
                {attachment.content.docList.length}
                篇资料作为参考：
              </p>
              <div className="flex flex-col gap-[9px]">
                { attachment.content.docList.map((doc, docIdx) => (
                  <Link size="sm" key={doc.docId} isExternal href={doc.docId} showAnchorIcon underline="hover">
                    {docIdx + 1}
                    .
                    {' '}
                    {doc.docName}
                  </Link>
                ))}
              </div>
            </div>

          )}
        </div>
      ))}
    </div>
  )
}
