import React from 'react'
import { motion } from 'framer-motion'
import styles from './GradientBackground.module.less'

export const GradientBackground: React.FC = () => {
  return (
    <motion.div
      className={`${styles.gradientBackground} hidden sm:block`}
    >
      {/* <motion.img src={Bg} alt="" /> */}
      <svg className={`${styles.animateSpotlight} pointer-events-none absolute left top-0 z-[1] h-[100%] w-[128%] opacity-0`} xmlns="http://www.w3.org/2000/svg" viewBox="0 0 2787 2842" fill="none">
        <g filter="url(#filter)"><ellipse cx="2524.71" cy="3.501" rx="1224.71" ry="803.501" transform="matrix(-0.822377 -0.568943 -0.568943 1.22377 3631.88 2391.09)" fill="#B6B4FF" fillOpacity="0.21"></ellipse></g>
        <defs>
          <filter id="filter" x="0.860352" y="0.838989" width="3785.16" height="2840.26" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
            <feFlood floodOpacity="0" result="BackgroundImageFix"></feFlood>
            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
            <feGaussianBlur stdDeviation="151" result="effect1_foregroundBlur_1065_8"></feGaussianBlur>
          </filter>
        </defs>
      </svg>

    </motion.div>
  )
}
