'use client'
import React, { useRef } from 'react'
import {
  motion,
  useScroll,
  useSpring,
} from 'framer-motion'
import { cn } from '@/lib/utils'
import './index.less'

interface TracingBeamProps {
  children: React.ReactNode
  className?: string
}

export default function TracingBeam({
  children,
  className,
}: TracingBeamProps) {
  const ref = useRef<HTMLDivElement>(null)
  const scrollableRef = useRef<HTMLDivElement>(null)

  const { scrollYProgress } = useScroll({
    container: scrollableRef,
  })
  const scaleX = useSpring(scrollYProgress, {
    stiffness: 100,
    damping: 30,
    restDelta: 0.001,
  })

  return (
    <div ref={scrollableRef} className="w-full overflow-auto scrollbar-hide scroll-smooth">
      <motion.div
        ref={ref}
        className={cn('relative w-full mx-auto', className)}
      >
        <motion.div className="progress-bar" style={{ scaleX }} />
        <div>{children}</div>
      </motion.div>
    </div>
  )
}
