interface AttachmentContentDoc {
  knowledgeName: string
  collectionName: string
  documentName: string
  documentAlias: string
  documentStoreKey: string
}

interface AttachmentContentProduct {
  productName: string
  productCode: string
}

export interface AttachmentContentEmailItem {
  sendName: string
  emailAddr: string
}

interface AttachmentContent {
  docList: AttachmentContentDoc[]
  description: string
  productList: AttachmentContentProduct[]
  url: string
  // Email相关字段
  title?: string
  mailMsg?: string
  receiver?: string
  emailList?: AttachmentContentEmailItem[]
}

export interface Attachment {
  type: string
  name: string
  url: string
  description: string
  content: AttachmentContent
}

export interface AnswerStep {
  step: string
  message: string
}

export interface AnswerExtra {
  executorName?: string
  optimizedQuestion?: string
  executorBeanName?: string
  step?: AnswerStep
}

export interface Answer {
  endAnswerFlag?: boolean
  endAnswer?: boolean
  endCardFlag?: boolean
  isStopTyping?: boolean
  isChatMaxCount?: boolean
  isShow: boolean
  answer: string
  collectionFlag?: boolean
  feedbackStatus?: string
  groupId?: string
  question?: string
  recordId?: string
  conversationId?: string
  terminateFlag?: boolean
  toolName?: string
  toolId?: string
  cardList: Attachment[]
  step?: AnswerStep
  recordType?: string
  busiType?: string
  ordType?: string
  extra?: AnswerExtra
  qaTime?: number | string
}

export interface OriginalRecord {
  answer?: string
  groupId?: string
  question?: string
  answerList: Answer[]
  productCode?: string
  qaTime?: string
  toolId?: string
}

export type ChatRecordRole = 'system' | 'user' | 'ai'

export interface ChatRecord extends OriginalRecord {
  role: ChatRecordRole
}

export interface ChatState {
  records: ChatRecord[]
  isLoading: boolean
  error: string | null
}
