import './App.css'
import { Button } from '@nextui-org/button'
import { useToggle } from '@reactuses/core'
import { motion } from 'framer-motion'
import React from 'react'

const App: React.FC = () => {
  const [on, toggle] = useToggle(true)

  return (
    <div>
      <motion.div
        className="w-[100px] h-[100px] bg-slate-300"
      >
        {on ? 'ON' : 'OFF'}
      </motion.div>
      <Button color="primary" onClick={toggle}>Toggle</Button>
    </div>
  )
}

export default App
