import './App.css'
import React from 'react'
import { BrowserRouter as Router } from 'react-router-dom'
import { Provider } from 'react-redux'
import { MainLayout } from './layouts'
import { AppRoutes } from './routes/AppRoutes'
import { AuthProvider } from './auth/AuthContext'
import ToastWrapper from './components/ToastWrapper/ToastWrapper'
import { store } from './store'

const viteOutputObj = import.meta.env.VITE_OUTPUT_OBJ || 'open'
const basename = viteOutputObj === 'inner' ? '/sdream-fe' : '/sdream-ai'

const App: React.FC = () => {
  return (
    <Provider store={store}>
      <ToastWrapper>
        <AuthProvider>
          <Router basename={basename}>
            <MainLayout>
              <AppRoutes />
            </MainLayout>
          </Router>
        </AuthProvider>
      </ToastWrapper>
    </Provider>

  )
}

export default App
