import type React from 'react'
import { motion } from 'framer-motion'
import { useToggle } from '@reactuses/core'
import { Button, Input } from '@nextui-org/react'
import { Navbar } from '../Navbar'
import styles from './MainLayout.module.less'
import SearchIcon from '@/assets/svg/search.svg?react'

interface MainLayoutProps {
  children: React.ReactNode
}

export const MainLayout: React.FC<MainLayoutProps> = ({ children }) => {
  const [isNavCollapsed, toggleNav] = useToggle(true)

  const list = {
    hidden: { opacity: 1, scale: 0 },
    visible: {
      opacity: 1,
      scale: 1,
      transition: {
        delayChildren: 0.2,
        staggerChildren: 0.1,
      },
    },
  }

  const item = {
    hidden: { y: 20, opacity: 0 },
    visible: {
      y: 0,
      opacity: 1,
    },
  }

  return (
    <motion.main className={styles.layoutMain}>
      <div className="w-90px h-full pl-[12px] flex items-center">
        <Navbar isCollapsed={isNavCollapsed} onToggle={toggleNav} />
        {isNavCollapsed && (
          <div className="w-[252px] bg-[#F0FAFF] rounded-[20px] border-[1px] border-solid border-white ml-[12px]">
            <div className="pt-[24px] px-[32px]">
              <Input classNames={{ inputWrapper: ['bg-white', 'data-[hover=true]:bg-[#fff]', 'group-data-[focus=true]:bg-white', 'rounded-[24px]'] }} placeholder="搜索历史记录" startContent={<SearchIcon />} />
              <motion.ul
                initial="hidden"
                animate="visible"
                variants={list}
                className="w-full flex flex-col gap-[6px]"
              >
                <motion.li variants={item} className="mt-[32px] text-[13px] text-[#B1C6D2]">今日</motion.li>
                <motion.li variants={item} className="w-full">
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
                <motion.li variants={item} className="w-full">
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
                <motion.li variants={item} className="w-full">
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
                <motion.li variants={item} className="w-full">
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
                <motion.li variants={item} className="w-full">
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
                <motion.li variants={item} className="w-full">
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
                <motion.li variants={item} className="mt-[32px] text-[13px] text-[#B1C6D2]">今日</motion.li>
                <motion.li variants={item} className="w-full">
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
              </motion.ul>
            </div>
            <div className="w-full h-[48px] flex items-center justify-center">
              管理对话记录
            </div>
          </div>
        )}

      </div>
      <motion.div className={styles.layoutContent}>
        {children}
      </motion.div>
    </motion.main>
  )
}
