import React from 'react'
import { Route, Routes } from 'react-router-dom'
import { Home } from '../pages/Home'
import { Chat as ChatDefault } from '../pages/Chat'
import { Chat as ChatTactics } from '../pages/ChatTactics'
import { Collect } from '../pages/Collect'
import { Tools } from '../pages/Tools'
import { Protocol } from '../pages/Protocol'
import { withRouteChangeHandler } from './RouteChangeHandler'

const ChatEntry: React.FC = () => {
  const params = new URLSearchParams(window.location.search)
  const isFromTactics = params.get('from') === 'tactics'
  return isFromTactics ? <ChatTactics /> : <ChatDefault />
}

const AppRoutesComponent: React.FC = () => {
  return (
    <Routes>
      <Route path="/" element={<Home />}>
        <Route path="/chat/:id" element={<ChatEntry />} />
      </Route>
      <Route path="/home" element={<Home />}></Route>
      <Route path="/collect" element={<Collect />} />
      <Route path="/tools" element={<Tools />} />
      <Route path="/protocol/:id" element={<Protocol />} />
    </Routes>
  )
}

export const AppRoutes = withRouteChangeHandler(AppRoutesComponent)
