import React, { useEffect } from 'react'
import { useParams } from 'react-router-dom'
import { useAppDispatch, useAppSelector } from '@/store/hook'
import { setCurrentConversation } from '@/store/conversationSlice'

export const Chat: React.FC = () => {
  const { id } = useParams<{ id: string }>()
  const dispatch = useAppDispatch()
  const { currentConversationId } = useAppSelector(state => state.conversation)

  useEffect(() => {
    if (id && id !== currentConversationId) {
      dispatch(setCurrentConversation(id))
      // dispatch(fetchConversationDetails(id))
    }
  }, [id, currentConversationId, dispatch])
  return (
    <h1>
      聊天页面 - Chat ID:
      {id}
    </h1>
  )
}
