import { Button, Link } from '@nextui-org/react'
import { motion } from 'framer-motion'
import type { Answer } from '@/types/chat'
import AnswerProDetailIcon from '@/assets/svg/answerProDetail.svg?react'
import CardNavImg from '@/assets/card-nav.png'
import CardCalculation from '@/assets/card-calculation.png'
import CardDetailImg from '@/assets/card-detail.png'
import CardPlansImg from '@/assets/card-book1111.png'
import CardProductCompareImg from '@/assets/card-product2222.png'
import { fetchGetDocumentLink } from '@/api/common'

interface ChatAnswerAttachmentProps {
  answer: Answer
  isLastAnswer?: boolean
  fromParser?: boolean
  onSubmitQuestion?: (question: string, productCode?: string) => void
}
export const ChatAnswerAttachment: React.FC<ChatAnswerAttachmentProps> = ({ fromParser, answer, isLastAnswer, onSubmitQuestion }) => {
  const handleClickBoxItem = (produceName: string, productCode: string) => {
    if (onSubmitQuestion) {
      onSubmitQuestion(produceName, productCode)
    }
  }

  const handleClickCard = (url: string) => {
    window.open(url)
  }

  const handleClickDocLink = async (docId: string) => {
    if (fromParser) {
      const res = await fetchGetDocumentLink(docId)
      if (res.data) {
        window.open(res.data.docUrl)
      }
    }
    else {
      window.open(docId)
    }
  }
  return (
    <div className="attachmentList flex flex-col gap-[20px]">
      {answer.attachmentList && answer.attachmentList.map((attachment, index) => (
        <div key={`${attachment.type}_${index}`}>
          {/* 附件：product-detail */}
          {attachment.type === 'product-detail' && (
            <div className="bg-[#29B6FD0A] text-[14px] text-primary py-[4px] px-[16px] w-fit flex items-center">
              <AnswerProDetailIcon />
              {/* <span className="ml-[6px]">{attachment.name}</span> */}
              <div className="ml-[6px] w-[120px] sm:w-full text-nowrap text-ellipsis overflow-hidden">
                {attachment.name}
              </div>
            </div>
          )}

          {/* 附件：引用文件 */}
          {attachment.type === 'reference' && attachment.content.docList.length !== 0 && (
            <div>
              <p className="text-[14px] text-[#8D9795] mb-[12px]">
                已为您找到
                {attachment.content.docList.length}
                篇资料作为参考：
              </p>
              <div className="flex flex-col gap-[9px]">
                { attachment.content.docList.map((doc, docIdx) => (
                  <Link className="cursor-pointer" onPress={() => handleClickDocLink(doc.docId)} size="sm" key={doc.docId} isExternal showAnchorIcon underline="hover">
                    {docIdx + 1}
                    .
                    {' '}
                    {doc.docName}
                  </Link>
                ))}
              </div>
            </div>

          )}

          {/* 附件：选择 box */}
          {
            attachment.type === 'box' && attachment.content.productList.length !== 0 && (
              <div>
                <div className="mb-[12px]">{attachment.description}</div>
                <ul
                  className="flex flex-col gap-[8px]"
                >
                  {attachment.content.productList.map(product => (
                    // <div key={product.productCode}>{product.productName}</div>
                    <motion.li
                      key={product.productCode}
                    >
                      <Button onClick={() => handleClickBoxItem(product.productName, product.productCode)} isDisabled={!isLastAnswer} color="primary" variant="light" className="text-left bg-[#F7FCFF] w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                        <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                          <span className="ml-[8px]">{product.productName}</span>
                        </div>
                      </Button>
                    </motion.li>
                  ))}
                </ul>
              </div>
            )
          }

          {
            attachment.type?.includes('card-') && (
              <div onClick={() => handleClickCard(attachment.url)}>
                {attachment.type === 'card-nav' && <img className="w-full max-w-[400px] cursor-pointer" src={CardNavImg} alt="" />}
                {attachment.type === 'card-detail' && <img className="w-full max-w-[400px] cursor-pointer" src={CardDetailImg} alt="" />}
                {attachment.type === 'card-calculation' && <img className="w-full max-w-[400px] cursor-pointer" src={CardCalculation} alt="" />}
                {attachment.type === 'card-product-compare' && <img className="w-full max-w-[400px] cursor-pointer" src={CardProductCompareImg} alt="" />}
                {attachment.type === 'card-plans' && <img className="w-full max-w-[400px] cursor-pointer" src={CardPlansImg} alt="" />}
              </div>
            )
          }
        </div>
      ))}
    </div>
  )
}
