// src/components/FilePreviewModal/PdfPreview.tsx
import React from 'react'

interface PdfPreviewProps {
  src: string
  className?: string
  onLoaded?: () => void
  onError?: (error: any) => void
}

export const PdfPreview: React.FC<PdfPreviewProps> = ({
  src,
  className = '',
  onLoaded,
  onError,
}) => {
  const handleLoad = () => {
    onLoaded?.()
  }

  const handleError = (_e: React.SyntheticEvent) => {
    onError?.(new Error('PDF加载失败'))
  }

  return (
    <div className={`${className} h-full flex flex-col`}>
      <div className="flex-grow overflow-hidden bg-gray-100">
        <embed
          src={src}
          type="application/pdf"
          className="w-full h-full border-0"
          onLoad={handleLoad}
          onError={handleError}
        />
      </div>
    </div>
  )
}
